/**
 * @(#)ItemActivityPriceQueryReqDto.java 1.0 2021/3/9
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 商品SkuDto
 *
 */
@ApiModel(value = "ItemSkuDto", description = "商品SkuDto")
public class ItemSkuDto implements Serializable {

    @ApiModelProperty(name = "itemId", value = "商品ID",required = true)
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "skuID",required = true)
    private Long skuId;

    @ApiModelProperty(name = "shopId", value = "店铺ID",required = true)
    private Long shopId;

    @ApiModelProperty(name = "shopOrgId", value = "店铺组织ID",required = true)
    private Long shopOrgId;

    /**
     * 促销价
     */
    @ApiModelProperty(name = "activityPrice", value = "促销价")
    private BigDecimal activityPrice;

    /**
     * 折扣：如8.55
     */
    @ApiModelProperty(name = "discount", value = "折扣")
    private BigDecimal discount;

    /**
     * 促销方式：1促销价格，2折扣
     */
    @ApiModelProperty(name = "promotionMethod", value = "促销方式：1促销价格，2折扣")
    private Integer promotionMethod;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "activityTag", value = "活动标签")
    private String activityTag;

    @ApiModelProperty(name = "activityTemplateId", value = "活动模板id")
    private Long activityTemplateId;

    @ApiModelProperty(name = "isCombinedPackage", value = "是否是组合套装：1是，0不是")
    private Integer isCombinedPackage = 0;

    @ApiModelProperty(value = "ifExchange", name = "换购商品：1是，0不是")
    private Integer ifExchange = 0;

    @ApiModelProperty(value = "exchangeActivityId", name = "换购活动id")
    private Long exchangeActivityId;

    public Integer getIsCombinedPackage() {
        return isCombinedPackage;
    }

    public void setIsCombinedPackage(Integer isCombinedPackage) {
        this.isCombinedPackage = isCombinedPackage;
    }

    public Integer getIfExchange() {
        return ifExchange;
    }

    public void setIfExchange(Integer ifExchange) {
        this.ifExchange = ifExchange;
    }

    public Long getExchangeActivityId() {
        return exchangeActivityId;
    }

    public void setExchangeActivityId(Long exchangeActivityId) {
        this.exchangeActivityId = exchangeActivityId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }

    public Long getActivityTemplateId() {
        return activityTemplateId;
    }

    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    public BigDecimal getActivityPrice() {
        return activityPrice;
    }

    public void setActivityPrice(BigDecimal activityPrice) {
        this.activityPrice = activityPrice;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public Integer getPromotionMethod() {
        return promotionMethod;
    }

    public void setPromotionMethod(Integer promotionMethod) {
        this.promotionMethod = promotionMethod;
    }

    public Long getShopOrgId() {
        return shopOrgId;
    }

    public void setShopOrgId(Long shopOrgId) {
        this.shopOrgId = shopOrgId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }
}
