/**
 * @(#) ActivityTemplateReqDto.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 活动模版查询请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ActionTemplateQueryReqDto", description = "动作模版查询请求Dto")
public class ActionTemplateQueryReqDto extends RequestDto {

    private static final long serialVersionUID = -5519614098094027538L;
    /**
     * 模板名称
     */
    @ApiModelProperty(name = "templateName", value = "模板名称")
    private String templateName;

    /**
     * 脚本解析方式（PREPARE：预编译、RUNTIME：运行时）
     */
    @ApiModelProperty(name = "scriptsType", value = "脚本解析方式（PREPARE：预编译、RUNTIME：运行时）")
    private String scriptsType;

    /**
     * 是否远程执行（Y：是<参照物：营销中心>、N：否）
     */
    @ApiModelProperty(name = "isRemote", value = "是否远程执行（Y：是<参照物：营销中心>、N：否）")
    private String isRemote;

    /**
     * 权重值（1-1000，值越大，优先级越高）
     */
    @ApiModelProperty(name = "weight", value = "权重值（1-1000，值越大，优先级越高）")
    private Integer weight;

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getScriptsType() {
        return scriptsType;
    }

    public void setScriptsType(String scriptsType) {
        this.scriptsType = scriptsType;
    }

    public String getIsRemote() {
        return isRemote;
    }

    public void setIsRemote(String isRemote) {
        this.isRemote = isRemote;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }


}
