/**
 * @(#)ActivityAuditReqDto.java 1.0 2018年12月20日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 活动审批Dto
 *
 * @author 水镜
 * @since 2.0.0
 */
@ApiModel(value = "ActivityAuditReqDto", description = "活动审批Dto")
public class ActivityAuditReqDto extends RequestDto {

    private static final long serialVersionUID = 1L;

    /**
     * 审批人
     */
    @ApiModelProperty(name = "auditPerson", value = "审批人")
    @NotNull(message = "审批人不能为空")
    private Long auditPerson;

    /**
     * 父审批人
     */
    @ApiModelProperty(name = "parentAuditPerson", value = "父审批人")
    @NotNull
    private Long parentAuditPerson;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 审核状态（AUDIT_PASS：通过、AUDIT_REFUSE：驳回）
     */
    @ApiModelProperty(name = "auditStatus", value = "审核状态（AUDIT_PASS：通过、AUDIT_REFUSE：驳回）")
    @NotNull(message = "审核状态不能为空")
    private String auditStatus;

    public Long getAuditPerson() {
        return auditPerson;
    }

    public void setAuditPerson(Long auditPerson) {
        this.auditPerson = auditPerson;
    }

    public Long getParentAuditPerson() {
        return parentAuditPerson;
    }

    public void setParentAuditPerson(Long parentAuditPerson) {
        this.parentAuditPerson = parentAuditPerson;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

}
