/**
 * @(#)ActivityCreateReqDto.java 1.0 2018年12月18日
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.BizActivityType;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 活动创建dto
 *
 * @author 水镜
 * @since 2.0.0
 */
public class ActivityCreateReqDto extends RequestDto {

    private static final long serialVersionUID = 1L;

    /**
     * 活动信息
     */
    @ApiModelProperty(name = "activityDto", value = "活动信息")
    private ActivityDto activityDto;

    /**
     * 活动条件实例
     */
    @ApiModelProperty(name = "conditions", value = "活动条件实例")
    private List<ConditionReqDto> conditions;

    /**
     * 活动动作实例
     */
    @ApiModelProperty(name = "actions", value = "活动动作实例")
    private List<ActionReqDto> actions;


    /**
     * 活动商品
     */
    @ApiModelProperty(name = "activityItems", value = "活动商品")
    private List<ActivityItemReqDto> activityItems;

    /**
     * 活动规则商品
     */
    @ApiModelProperty(name = "activityRuleItems", value = "活动规则商品")
    private List<ActivityRuleItemReqDto> activityRuleItems;

    /**
     * 活动参与人
     */
    private List<Long> userIds;

    /**
     * 活动关系
     */
    @ApiModelProperty(name = "activityRelations", value = "活动关系")
    private List<ActivityRelationReqDto> activityRelations;

    @ApiModelProperty(name = "bizActivityType", value = "活动业务类型", required = false)
    private BizActivityType bizActivityType;

    @ApiModelProperty(name = "customerTypeIds", value = "客户类型")
    private String customerTypeIds;

    @ApiModelProperty(name = "customerAreaCodes", value = "客户区域")
    private String customerAreaCodes;

    public ActivityDto getActivityDto() {
        return activityDto;
    }

    public void setActivityDto(ActivityDto activityDto) {
        this.activityDto = activityDto;
    }

    public List<ConditionReqDto> getConditions() {
        return conditions;
    }

    public void setConditions(List<ConditionReqDto> conditions) {
        this.conditions = conditions;
    }

    public List<ActionReqDto> getActions() {
        return actions;
    }

    public void setActions(List<ActionReqDto> actions) {
        this.actions = actions;
    }

    public List<ActivityItemReqDto> getActivityItems() {
        return activityItems;
    }

    public void setActivityItems(List<ActivityItemReqDto> activityItems) {
        this.activityItems = activityItems;
    }

    public List<Long> getUserIds() {
        return userIds;
    }

    public void setUserIds(List<Long> userIds) {
        this.userIds = userIds;
    }

    public List<ActivityRelationReqDto> getActivityRelations() {
        return activityRelations;
    }

    public void setActivityRelations(List<ActivityRelationReqDto> activityRelations) {
        this.activityRelations = activityRelations;
    }

    public BizActivityType getBizActivityType() {
        return bizActivityType;
    }

    public void setBizActivityType(BizActivityType bizActivityType) {
        this.bizActivityType = bizActivityType;
    }

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getCustomerTypeIds() {
        return customerTypeIds;
    }

    public void setCustomerTypeIds(String customerTypeIds) {
        this.customerTypeIds = customerTypeIds;
    }

    public String getCustomerAreaCodes() {
        return customerAreaCodes;
    }

    public void setCustomerAreaCodes(String customerAreaCodes) {
        this.customerAreaCodes = customerAreaCodes;
    }

    public List<ActivityRuleItemReqDto> getActivityRuleItems() {
        return activityRuleItems;
    }

    public void setActivityRuleItems(List<ActivityRuleItemReqDto> activityRuleItems) {
        this.activityRuleItems = activityRuleItems;
    }
}
