/*
 * *
 *  * @(#)ActivityDto.java 2.0.0 18-11-28 下午3:09
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.alibaba.druid.sql.dialect.oracle.ast.clause.SampleClause;
import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.ActivityStatusEnum;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.AuditStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 活动Dto
 *
 * @author 水镜
 * @since 2.0.0
 */
@ApiModel(value = "ActivityDto", description = "活动Dto")
public class ActivityDto extends RequestDto {

    private static final long serialVersionUID = 1L;

    /**
     * 活动id
     */
    private Long id;
    /**
     * 活动名称
     */
    @ApiModelProperty(name = "activityName", value = "活动名字")
    private String activityName;
    /**
     * 活动logo
     */
    @ApiModelProperty(name = "activityLogo", value = "活动logo")
    private String activityLogo;
    /**
     * 活动销售数量
     */
    @ApiModelProperty(name = "activityLimit", value = "活动销售数量")
    private Long activityLimit;
    /**
     * 第三方Code
     */
    @ApiModelProperty(name = "thirdPartyCode", value = "第三方Code")
    private String thirdPartyCode;
    /**
     * 活动模板编号
     */
    @ApiModelProperty(name = "activityTemplateId", value = "活动模板编号")
    private Long activityTemplateId;

    /**
     * 内容模板编号
     */
    @ApiModelProperty(name = "contentTemplateId", value = "内容模板编号")
    private Long contentTemplateId;

    /**
     * 内容编号
     */
    @ApiModelProperty(name = "contentId", value = "内容编号")
    private Long contentId;

    /**
     * 开始时间
     */
    @ApiModelProperty(name = "beginTime", value = "开始时间")
    private Date beginTime;

    /**
     * 截止时间
     */
    @ApiModelProperty(name = "endTime", value = "截止时间")
    private Date endTime;

    /**
     * 定时执行表达式（quartz表达式）
     */
    @ApiModelProperty(name = "execExpression", value = "定时执行表达式（quartz表达式）")
    private String execExpression;

    /**
     * 预告时间（不为空，则调用预告逻辑，由定制实现）
     */
    @ApiModelProperty(name = "noticeTime", value = "预告时间（不为空，则调用预告逻辑，由定制实现）")
    private Date noticeTime;

    /**
     * 备注
     */
    @ApiModelProperty(name = "remark", value = "备注")
    private String remark;

    /**
     * 活动状态（NEW：新建、READY：就绪、ACTIVATE：活动中、TIMEOUT：暂停、FINISH：活动结束）
     */
    @ApiModelProperty(name = "activityStatusEnum", value = "活动状态")
    private ActivityStatusEnum activityStatusEnum;

    @ApiModelProperty(name = "activityStatus", value = "活动状态集合")
    private List<String> activityStatus;

    /**
     * 审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）
     */
    @ApiModelProperty(name = "auditStatusEnum", value = "审核状态")
    private AuditStatusEnum auditStatusEnum;
    /**
     * 审核状态（NEW：新建、WAIT_AUDIT：待审核、AUDIT_PASS：审核通过、AUDIT_REFUSE：审核不通过）
     */
    @ApiModelProperty(name = "auditStatusEnums", value = "审核状态s,跟auditStatusEnum一样只不过支持数组,两个都能用")
    private List<String> auditStatusEnums;

    /**
     * 促销方式（1：整单，2：单品）
     */
    @ApiModelProperty(name = "promotionMethod", value = "促销方式：1 整单，2 单品")
    private Integer promotionMethod;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段")
    private String extension;


    @ApiModelProperty(name = "sellerId", value = "商户ID")
    private Long sellerId;

    @ApiModelProperty(name = "shopId", value = "店铺ID")
    private Long shopId;

    @ApiModelProperty(name="activityType",value = "活动类型")
    private String activityType ;

    @ApiModelProperty(name="activityCode",value = "活动编码")
    private String activityCode;

    /**
     * 活动预热开始时间
     */
    @ApiModelProperty(name = "preheatStartTime", value = "活动预热开始时间")
    private Date preheatStartTime;

    /**
     * 活动预热结束时间
     */
    @ApiModelProperty(name = "preheatEndTime", value = "活动预热结束时间")
    private Date preheatEndTime;

    @ApiModelProperty(name = "tag", value = "活动标签")
    private String tag;

    @ApiModelProperty(name = "tagType", value = "活动标签类型：0 默认 1 自定义")
    private Integer tagType;

    @ApiModelProperty(name = "activityTemplateIds", value = "活动模板id集合")
    private List<Long> activityTemplateIds;

    /**
     * 组织id
     */
    @ApiModelProperty(name = "organizationId", value = "组织id")
    private Long organizationId;

    /**
     * 组织名称
     */
    @ApiModelProperty(name = "organizationName", value = "组织名称")
    private String organizationName;

    @ApiModelProperty(name = "activityIds", value = "活动id列表")
    private List<Long> activityIds;

    @ApiModelProperty(name = "returnGoods", value = "赠品售后：true需退货，false不需要退货")
    private Boolean returnGoods;

    @ApiModelProperty(name = "selectType", value = "适用商品：0不限，1指定商品，2指定品类，")
    private Integer  selectType;

    @ApiModelProperty(name = "selectCustomer", value = "适用客户：0不限，1指定类型，2指定客户")
    private Integer selectCustomer;

    @ApiModelProperty(name = "outActivityIds", value = "在活动ID集合外查询")
    private List<Long> outActivityIds;

    @ApiModelProperty(name = "ifBalanceAccount", value = "是否额度累积：0 否 1 是")
    private Integer ifBalanceAccount;

    public Integer getIfBalanceAccount() {
        return ifBalanceAccount;
    }

    public void setIfBalanceAccount(Integer ifBalanceAccount) {
        this.ifBalanceAccount = ifBalanceAccount;
    }

    public String getThirdPartyCode() {
        return thirdPartyCode;
    }

    public void setThirdPartyCode(String thirdPartyCode) {
        this.thirdPartyCode = thirdPartyCode;
    }

    public List<Long> getOutActivityIds() {
        return outActivityIds;
    }

    public void setOutActivityIds(List<Long> outActivityIds) {
        this.outActivityIds = outActivityIds;
    }

    public Long getSellerId() {
        return sellerId;
    }

    public void setSellerId(Long sellerId) {
        this.sellerId = sellerId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<String> getAuditStatusEnums() {
        return auditStatusEnums;
    }

    public void setAuditStatusEnums(List<String> auditStatusEnums) {
        this.auditStatusEnums = auditStatusEnums;
    }

    /**
     * 设置活动名称
     */
    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    /**
     * 获取活动名称
     */
    public String getActivityName() {
        return this.activityName;
    }

    /**
     * 设置活动模板编号
     */
    public void setActivityTemplateId(Long activityTemplateId) {
        this.activityTemplateId = activityTemplateId;
    }

    /**
     * 获取活动模板编号
     */
    public Long getActivityTemplateId() {
        return this.activityTemplateId;
    }

    /**
     * 设置内容模板编号
     */
    public void setContentTemplateId(Long contentTemplateId) {
        this.contentTemplateId = contentTemplateId;
    }

    /**
     * 获取内容模板编号
     */
    public Long getContentTemplateId() {
        return this.contentTemplateId;
    }

    /**
     * 设置内容编号
     */
    public void setContentId(Long contentId) {
        this.contentId = contentId;
    }

    /**
     * 获取内容编号
     */
    public Long getContentId() {
        return this.contentId;
    }

    /**
     * 设置开始时间
     */
    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    /**
     * 获取开始时间
     */
    public Date getBeginTime() {
        return this.beginTime;
    }

    /**
     * 设置截止时间
     */
    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    /**
     * 获取截止时间
     */
    public Date getEndTime() {
        return this.endTime;
    }

    /**
     * 设置定时执行表达式（quartz表达式）
     */
    public void setExecExpression(String execExpression) {
        this.execExpression = execExpression;
    }

    /**
     * 获取定时执行表达式（quartz表达式）
     */
    public String getExecExpression() {
        return this.execExpression;
    }

    /**
     * 设置预告时间（不为空，则调用预告逻辑，由定制实现）
     */
    public void setNoticeTime(Date noticeTime) {
        this.noticeTime = noticeTime;
    }

    /**
     * 获取预告时间（不为空，则调用预告逻辑，由定制实现）
     */
    public Date getNoticeTime() {
        return this.noticeTime;
    }

    /**
     * 设置备注
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }

    /**
     * 获取备注
     */
    public String getRemark() {
        return this.remark;
    }

    public ActivityStatusEnum getActivityStatusEnum() {
        return activityStatusEnum;
    }

    public void setActivityStatusEnum(ActivityStatusEnum activityStatusEnum) {
        this.activityStatusEnum = activityStatusEnum;
    }

    public AuditStatusEnum getAuditStatusEnum() {
        return auditStatusEnum;
    }

    public void setAuditStatusEnum(AuditStatusEnum auditStatusEnum) {
        this.auditStatusEnum = auditStatusEnum;
    }

    /**
     * 设置扩展字段，存放json
     */
    public void setExtension(String extension) {
        this.extension = extension;
    }

    /**
     * 获取扩展字段，存放json
     */
    public String getExtension() {
        return this.extension;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public Date getPreheatStartTime() {
        return preheatStartTime;
    }

    public void setPreheatStartTime(Date preheatStartTime) {
        this.preheatStartTime = preheatStartTime;
    }

    public Date getPreheatEndTime() {
        return preheatEndTime;
    }

    public void setPreheatEndTime(Date preheatEndTime) {
        this.preheatEndTime = preheatEndTime;
    }

    public List<String> getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(List<String> activityStatus) {
        this.activityStatus = activityStatus;
    }

    public String getTag() {
        return tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public List<Long> getActivityTemplateIds() {
        return activityTemplateIds;
    }

    public void setActivityTemplateIds(List<Long> activityTemplateIds) {
        this.activityTemplateIds = activityTemplateIds;
    }

    public Long getOrganizationId() {
        return organizationId;
    }

    public void setOrganizationId(Long organizationId) {
        this.organizationId = organizationId;
    }

    public String getOrganizationName() {
        return organizationName;
    }

    public void setOrganizationName(String organizationName) {
        this.organizationName = organizationName;
    }

    public List<Long> getActivityIds() {
        return activityIds;
    }

    public void setActivityIds(List<Long> activityIds) {
        this.activityIds = activityIds;
    }

    public Integer getPromotionMethod() {
        return promotionMethod;
    }

    public void setPromotionMethod(Integer promotionMethod) {
        this.promotionMethod = promotionMethod;
    }

    public Boolean getReturnGoods() {
        return returnGoods;
    }

    public void setReturnGoods(Boolean returnGoods) {
        this.returnGoods = returnGoods;
    }

    public Integer getSelectType() {
        return selectType;
    }

    public void setSelectType(Integer selectType) {
        this.selectType = selectType;
    }

    public Integer getSelectCustomer() {
        return selectCustomer;
    }

    public void setSelectCustomer(Integer selectCustomer) {
        this.selectCustomer = selectCustomer;
    }

    public Integer getTagType() {
        return tagType;
    }

    public void setTagType(Integer tagType) {
        this.tagType = tagType;
    }

    public String getActivityLogo() {
        return activityLogo;
    }

    public void setActivityLogo(String activityLogo) {
        this.activityLogo = activityLogo;
    }

    public Long getActivityLimit() {
        return activityLimit;
    }

    public void setActivityLimit(Long activityLimit) {
        this.activityLimit = activityLimit;
    }
}