/*
 * *
 *  * @(#)GiftReqDto.java 2.0.0 18-10-10 上午11:12
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 赠品信息承载dto
 * 
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel(value = "ActivityItemQueryReqDto", description = "活动商品DTO")
public class ActivityItemQueryReqDto extends CommonVo {

	private static final long serialVersionUID = 3224042260593901560L;

	/**
	 * 商品类型（ITEM：商品、GIFT：赠品）
	 */
	@ApiModelProperty(name = "itemType", value = "商品类型（ITEM：商品、GIFT：赠品）")
	private String itemType;
	/**
	 * 商品ID
	 */
	@ApiModelProperty(name = "itemId", value = "商品ID")
	private Long itemId;
	/**
	 * sku_id
	 */
	@ApiModelProperty(name = "skuId", value = "skuId")
	private Long skuId;
	/**
	 * 商品名称
	 */
	@ApiModelProperty(name = "itemName", value = "商品名称")
	private String itemName;
	/**
	 * 商品分类编码
	 */
	@ApiModelProperty(name = "categoryCode", value = "商品分类编码")
	private String categoryCode;

	/**
	 * 活动库存
	 */
	@ApiModelProperty(name = "originalStock", value = "活动库存")
	private Long originalStock;
	/**
	 * 活动ID
	 */
	@ApiModelProperty(name = "activityId", value = "活动ID")
	private Long activityId;

	/**
	 * 活动价格（单位：元）
	 */
	@ApiModelProperty(name = "activityPrice", value = "活动价格")
	private BigDecimal activityPrice;
	/**
	 * 活动PV
	 */
	@ApiModelProperty(name = "activityPv", value = "活动PV")
	private Long activityPv;
	/**
	 * 状态（NEW：新增、ENABLED：启用、DIABLED：禁用）
	 */
	@ApiModelProperty(name = "status", value = "状态（NEW：新增、ENABLED：启用、DIABLED：禁用）")
	private String status;

	@ApiModelProperty(name = "shopId", value = "店铺id")
	private Long shopId;

	public String getItemType() {
		return itemType;
	}

	public void setItemType(String itemType) {
		this.itemType = itemType;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getSkuId() {
		return skuId;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public Long getOriginalStock() {
		return originalStock;
	}

	public void setOriginalStock(Long originalStock) {
		this.originalStock = originalStock;
	}

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public BigDecimal getActivityPrice() {
		return activityPrice;
	}

	public void setActivityPrice(BigDecimal activityPrice) {
		this.activityPrice = activityPrice;
	}

	public Long getActivityPv() {
		return activityPv;
	}

	public void setActivityPv(Long activityPv) {
		this.activityPv = activityPv;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Long getShopId() {
		return shopId;
	}

	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}
}
