/**
 * @(#)ActivityRelationReqDto.java 1.0 2021/3/9
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 活动叠加关系dto
 *
 * @author wu.sheng
 * @date 2021/3/9 14:45
 */
@ApiModel(value = "ActivityRelationReqDto", description = "活动关系请求dto")
public class ActivityRelationReqDto {

    /**
     * 目标活动模板id
     */
    @ApiModelProperty(name = "targetTemplateId", value = "目标模板id")
    private Long targetTemplateId;

    /**
     * 关系：0互斥，1叠加
     */
    @ApiModelProperty(name = "relation", value = "关系：0互斥，1叠加")
    private Integer relation;

    @ApiModelProperty(name = "bizId", value = "业务id")
    private Long bizId;

    @ApiModelProperty(name = "sourceTemplateId", value = "源模板id")
    private Long sourceTemplateId;

    /**
     * 目标活动id
     */
    @ApiModelProperty(name = "targetActivityId", value = "目标活动id")
    private Long targetActivityId;

    /**
     * 关系：0互斥，1叠加
     */
    @ApiModelProperty(name = "targetType", value = "目标类型（0：活动模板、1：具体活动）")
    private Integer targetType;

    public Long getTargetActivityId() {
        return targetActivityId;
    }

    public void setTargetActivityId(Long targetActivityId) {
        this.targetActivityId = targetActivityId;
    }

    public Integer getTargetType() {
        return targetType;
    }

    public void setTargetType(Integer targetType) {
        this.targetType = targetType;
    }

    public Long getTargetTemplateId() {
        return targetTemplateId;
    }

    public void setTargetTemplateId(Long targetTemplateId) {
        this.targetTemplateId = targetTemplateId;
    }

    public Integer getRelation() {
        return relation;
    }

    public void setRelation(Integer relation) {
        this.relation = relation;
    }

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public Long getSourceTemplateId() {
        return sourceTemplateId;
    }

    public void setSourceTemplateId(Long sourceTemplateId) {
        this.sourceTemplateId = sourceTemplateId;
    }
}
