/**
 * @(#) ActivityTemplateReqDto.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 活动模版查询请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ActivityTemplateQueryReqDto", description = "活动模版查询请求Dto")
public class ActivityTemplateQueryReqDto extends RequestDto {

    private static final long serialVersionUID = -2927703199634478725L;
    /**
     * 模版编码
     */
    @ApiModelProperty(name = "templateCode", value = "模版编码")
    private String templateCode;
    /**
     * 模版名称
     */
    @ApiModelProperty(name = "templateName", value = "模版名称")
    private String templateName;
    /**
     * 内容模版编号
     */
    @ApiModelProperty(name = "contentTemplateId", value = "内容模版编号")
    private Long contentTemplateId;

    /**
     * 活动类型（OLTP：离线处理<营销类>、OLAP：实时处理<促销类>）
     */
    @ApiModelProperty(name = "activityType", value = "活动类型（OLTP：离线处理-营销类、OLAP：实时处理-促销类）")
    private String activityType;
    /**
     * 模板状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "templateStatus", value = "模板状态（ENABLE：启用、DISABLE：停用）")
    private EnableStatusEnum templateStatusEnum;
    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;
    /**
     * 创建起始时间
     */
    @ApiModelProperty(name = "createStartTime", value = "创建起始时间")
    private String createStartTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;


    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Long getContentTemplateId() {
        return contentTemplateId;
    }

    public void setContentTemplateId(Long contentTemplateId) {
        this.contentTemplateId = contentTemplateId;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public EnableStatusEnum getTemplateStatusEnum() {
        return templateStatusEnum;
    }

    public void setTemplateStatusEnum(EnableStatusEnum templateStatusEnum) {
        this.templateStatusEnum = templateStatusEnum;
    }

    public String getCreateStartTime() {
        return createStartTime;
    }

    public void setCreateStartTime(String createStartTime) {
        this.createStartTime = createStartTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }


}
