/**
 * @(#) ActivityTemplateUpdateReqDto.java 1.0 2018-10-23
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * 活动模版更新请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "ActivityTemplateUpdateReqDto", description = "活动模版更新请求Dto")
public class ActivityTemplateUpdateReqDto extends RequestDto {
    private static final long serialVersionUID = -1536007967337846992L;
    /**
     * 模版编码
     */
    @ApiModelProperty(name = "templateCode", value = "模版编码")
    private String templateCode;
    /**
     * 模版名称
     */
    @ApiModelProperty(name = "templateName", value = "模版名称")
    private String templateName;
    /**
     * 内容模版编号
     */
    @ApiModelProperty(name = "contentTemplateId", value = "内容模版编号")
    private Long contentTemplateId;
//    /**
//     * 规则配置
//     */
//    @ApiModelProperty(name = "ruleConfig", value = "规则配置")
//    @NotNull(message = "配置规则不允许非空")
//    private String ruleConfig;
    /**
     * 活动类型（OLTP：离线处理<营销类>、OLAP：实时处理<促销类>）
     */
    @ApiModelProperty(name = "activityType", value = "活动类型（OLAP：离线处理-营销类、OLTP：实时处理-促销类）")
    private String activityType;
    /**
     * 模板状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "templateStatus", value = "模板状态（ENABLE：启用、DISABLE：停用）")
    private EnableStatusEnum templateStatusEnum;
    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;

    @ApiModelProperty(name = "policyIds" , value = "关联策略集合")
    private Set<Long> policyIds ;


    public Set<Long> getPolicyIds() {
        return policyIds;
    }

    public void setPolicyIds(Set<Long> policyIds) {
        this.policyIds = policyIds;
    }

    public String getTemplateCode() {
        return templateCode;
    }

    public void setTemplateCode(String templateCode) {
        this.templateCode = templateCode;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public Long getContentTemplateId() {
        return contentTemplateId;
    }

    public void setContentTemplateId(Long contentTemplateId) {
        this.contentTemplateId = contentTemplateId;
    }

    public String getActivityType() {
        return activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public EnableStatusEnum getTemplateStatusEnum() {
        return templateStatusEnum;
    }

    public void setTemplateStatusEnum(EnableStatusEnum templateStatusEnum) {
        this.templateStatusEnum = templateStatusEnum;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }


}
