/**
 * @(#)ActivityUserMappingReqDto 1.0 2018-10-31
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 活动参与人请求Dto
 *
 * @author 双清
 */
@ApiModel(value = "ActivityUserMappingReqDto", description = "活动参与人请求Dto")
public class ActivityUserMappingReqDto extends RequestDto {

    /**
     * 主键
     */
    @ApiModelProperty(name = "id", value = "主键")
    private Long id;

    /**
     * 活动实例编号
     */
    @ApiModelProperty(name = "activityId", value = "活动实例编号")
    private Long activityId;

    /**
     * 用户编号
     */
    @ApiModelProperty(name = "userId", value = "用户编号")
    private List<Long> userIdList;

    @ApiModelProperty(name = "customerTypeIds", value = "客户类型")
    private String customerTypeIds;

    @ApiModelProperty(name = "customerAreaCodes", value = "客户区域")
    private String customerAreaCodes;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public List<Long> getUserIdList() {
        return userIdList;
    }

    public void setUserIdList(List<Long> userIdList) {
        this.userIdList = userIdList;
    }

    public String getCustomerTypeIds() {
        return customerTypeIds;
    }

    public void setCustomerTypeIds(String customerTypeIds) {
        this.customerTypeIds = customerTypeIds;
    }

    public String getCustomerAreaCodes() {
        return customerAreaCodes;
    }

    public void setCustomerAreaCodes(String customerAreaCodes) {
        this.customerAreaCodes = customerAreaCodes;
    }
}