/**
 * @(#) ActivityTemplateReqDto.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 检查点查询请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "CheckPointQueryReqDto", description = "检查点查询请求Dto")
public class CheckPointQueryReqDto extends RequestDto {

    /**
     * 检查点编码
     */
    @ApiModelProperty(name = "checkpointCode", value = "检查点编码")
    private String checkpointCode;

    /**
     * 检查点名称
     */
    @ApiModelProperty(name = "checkpointName", value = "检查点名称")
    private String checkpointName;

    /**
     * 状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "checkpointStatus", value = " 状态（ENABLE：启用、DISABLE：停用）")
    private EnableStatusEnum checkpointStatusEnum;

    /**
     * 创建起始时间
     */
    @ApiModelProperty(name = "createStartTime", value = "创建起始时间")
    private String createStartTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;


    public String getCheckpointCode() {
        return checkpointCode;
    }

    public void setCheckpointCode(String checkpointCode) {
        this.checkpointCode = checkpointCode;
    }

    public String getCheckpointName() {
        return checkpointName;
    }

    public void setCheckpointName(String checkpointName) {
        this.checkpointName = checkpointName;
    }

    public EnableStatusEnum getCheckpointStatusEnum() {
        return checkpointStatusEnum;
    }

    public void setCheckpointStatusEnum(EnableStatusEnum checkpointStatusEnum) {
        this.checkpointStatusEnum = checkpointStatusEnum;
    }

    public String getCreateStartTime() {
        return createStartTime;
    }

    public void setCreateStartTime(String createStartTime) {
        this.createStartTime = createStartTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }


}
