/*
 * *
 *  * @(#)CheckpointReqDto.java 2.0.0 18-11-28 下午2:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "CheckPointReqDto", description = "检查点请求Dto")
public class CheckPointReqDto extends RequestDto {

    private static final long serialVersionUID = 8598022181062130455L;
    /**
     * 检查点编码
     */
    @ApiModelProperty(name = "checkpointCode", value = "检查点编码")
    private String checkpointCode;

    /**
     * 检查点名称
     */
    @ApiModelProperty(name = "checkpointName", value = "检查点名称")
    private String checkpointName;

    /**
     * 描述
     */
    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    /**
     * 状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "checkpointStatus", value = " 状态（ENABLE：启用、DISABLE：停用）")
    private String checkpointStatus;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;


    public String getCheckpointCode() {
        return checkpointCode;
    }

    public void setCheckpointCode(String checkpointCode) {
        this.checkpointCode = checkpointCode;
    }

    public String getCheckpointName() {
        return checkpointName;
    }

    public void setCheckpointName(String checkpointName) {
        this.checkpointName = checkpointName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCheckpointStatus() {
        return checkpointStatus;
    }

    public void setCheckpointStatus(String checkpointStatus) {
        this.checkpointStatus = checkpointStatus;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
