package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.TemplateDefine;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;

/**
 * 条件模板
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "ConditionTemplateReqDto", description = "条件模版请求Dto")
public class ConditionTemplateReqDto extends RequestDto {

    private static final long serialVersionUID = -6516275046863020868L;
    /**
     * 模板名称
     */
    @ApiModelProperty(name = "templateName", value = "模板名称")
    private String templateName;

    /**
     * 条件模板定义
     */
    @ApiModelProperty(name = "conditionDefine", value = "条件模板定义")
    @NotNull
    private TemplateDefine conditionDefineDto;

    /**
     * 解析脚本
     */
    @ApiModelProperty(name = "scripts", value = "解析脚本")
    private String scripts;

    /**
     * 脚本解析方式（PREPARE：预编译、RUNTIME：运行时）
     */
    @ApiModelProperty(name = "scriptsType", value = "脚本解析方式（PREPARE：预编译、RUNTIME：运行时）")
    private String scriptsType;

    /**
     * 是否远程执行（Y：是<参照物：营销中心>、N：否）
     */
    @ApiModelProperty(name = "isRemote", value = "是否远程执行（Y：是<参照物：营销中心>、N：否）")
    private String isRemote;

    /**
     * 权重值（1-1000，值越大，优先级越高）
     */
    @ApiModelProperty(name = "weight", value = "权重值（1-1000，值越大，优先级越高）")
    private Integer weight;
    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;


    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public TemplateDefine getConditionDefineDto() {
        return conditionDefineDto;
    }

    public void setConditionDefineDto(TemplateDefine conditionDefineDto) {
        this.conditionDefineDto = conditionDefineDto;
    }

    public String getScripts() {
        return scripts;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }

    public String getScriptsType() {
        return scriptsType;
    }

    public void setScriptsType(String scriptsType) {
        this.scriptsType = scriptsType;
    }

    public String getIsRemote() {
        return isRemote;
    }

    public void setIsRemote(String isRemote) {
        this.isRemote = isRemote;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
