/*
 * *
 *  * @(#)EngineParamsReqDto.java 2.0.0 19-1-7 下午4:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author luo.lei
 * @since 2.0.0
 */
public class EngineParamsReqDto extends RequestDto {


    private static final long serialVersionUID = 1578885510905666289L;
    protected long activityId;
    protected long couponTemplateId;
    protected List<Long> couponIds;
    /**
     * 用户编号
     */
    protected long userId;

    protected List<ItemVo> items;

    protected double freight;

    protected double targetFreight;

    /**
     * 所属系统
     */
    protected String programSrc;

    /**
     * 由使用者定义具体意义
     */
    protected String serialNumber;

    public double getFreight() {
        return freight;
    }

    public void setFreight(double freight) {
        this.targetFreight = freight;
        this.freight = freight;
    }

    public double getTargetFreight() {
        return targetFreight;
    }

    public void setTargetFreight(double targetFreight) {
        this.targetFreight = targetFreight;
    }

    public long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public long getActivityId() {
        return activityId;
    }

    public Object getResponse() {
        return null;
    }

    public List<ItemVo> getItems() {
        return items;
    }

    public void setItems(List<ItemVo> items) {
        this.items = items;
    }

    public String getProgramSrc() {
        return programSrc;
    }

    public void setProgramSrc(String programSrc) {
        this.programSrc = programSrc;
    }

    public String getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setActivityId(long activityId) {
        this.activityId = activityId;
    }

    public long getCouponTemplateId() {
        return couponTemplateId;
    }

    public void setCouponTemplateId(long couponTemplateId) {
        this.couponTemplateId = couponTemplateId;
    }

    public List<Long> getCouponIds() {
        return couponIds;
    }

    public void setCouponIds(List<Long> couponIds) {
        this.couponIds = couponIds;
    }

    public void setUserId(long userId) {
        this.userId = userId;
    }

    private Map<String, Object> extendAttributes;

    public Map<String, Object> getExtendAttributes() {
        return extendAttributes;
    }

    public void setExtendAttributes(Map<String, Object> extendAttributes) {
        this.extendAttributes = extendAttributes;
    }


    public static class ItemVo implements Serializable {
        private static final long serialVersionUID = 4503001680859184048L;
        private long itemId;
        private double price;
        private double targetPrice;
        private List<Long> itemCategory;
        private int num = 1;
        private long skuId;
        @ApiModelProperty(name = "couponId", value = "基于用户行为指定某商品使用某优惠券是使用该字段," +
                "但是如果存在一个就需要所有都使用该字段。否则使用外部的优惠券集合字段")
        private long couponId;
        private long sellerId;
        private long shopId;

        public ItemVo() {
        }

        public ItemVo(long itemId, double price, int num, long skuId, long couponId, long shopId, long sellerId, List<Long> itemCategory) {
            this.itemId = itemId;
            this.price = price;
            this.num = num;
            this.skuId = skuId;
            this.couponId = couponId;
            this.shopId = shopId;
            this.sellerId = sellerId;
            this.itemCategory = itemCategory;
        }

        public List<Long> getItemCategory() {
            return itemCategory;
        }

        public void setItemCategory(List<Long> itemCategory) {
            this.itemCategory = itemCategory;
        }

        public int getNum() {
            return num;
        }

        public void setNum(int num) {
            this.num = num;
        }

        public long getItemId() {
            return itemId;
        }

        public void setItemId(long itemId) {
            this.itemId = itemId;
        }

        public double getPrice() {
            return price;
        }

        public void setPrice(double price) {
            this.price = price;
        }

        public long getSkuId() {
            return skuId;
        }

        public void setSkuId(long skuId) {
            this.skuId = skuId;
        }

        public double getTargetPrice() {
            return targetPrice;
        }

        public void setTargetPrice(double targetPrice) {
            this.targetPrice = targetPrice;
        }

        public long getCouponId() {
            return couponId;
        }

        public void setCouponId(long couponId) {
            this.couponId = couponId;
        }

        public long getSellerId() {
            return sellerId;
        }

        public void setSellerId(long sellerId) {
            this.sellerId = sellerId;
        }

        public long getShopId() {
            return shopId;
        }

        public void setShopId(long shopId) {
            this.shopId = shopId;
        }

    }

}
