/**
 * @(#)ItemActivityPriceDto.java 1.0 2021/3/5
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;
import java.util.List;

/**
 * 商品活动价格dto
 *
 * @author wu.sheng
 * @date 2021/3/5 15:45
 */
@ApiModel(value = "ItemActivityPriceDto", description = "商品活动价格dto")
public class ItemActivityPriceDto extends BaseVo {

    private Long id;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "skuId", value = "规格id")
    private Long skuId;

    @ApiModelProperty(name = "price", value = "价格")
    private BigDecimal price;

    @ApiModelProperty(name = "type", value = "类型：1活动价，2折扣价")
    private Integer type;

    @ApiModelProperty(name = "activityList", value = "活动列表")
    private List<ActivitySimpleInfoDto> activityList;

    public ItemActivityPriceDto() {
    }

    public ItemActivityPriceDto(Long shopId, Long itemId) {
        this.shopId = shopId;
        this.itemId = itemId;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getSkuId() {
        return skuId;
    }

    public void setSkuId(Long skuId) {
        this.skuId = skuId;
    }

    public BigDecimal getPrice() {
        return price;
    }

    public void setPrice(BigDecimal price) {
        this.price = price;
    }

    public Integer getType() {
        return type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public List<ActivitySimpleInfoDto> getActivityList() {
        return activityList;
    }

    public void setActivityList(List<ActivitySimpleInfoDto> activityList) {
        this.activityList = activityList;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }
}
