/**
 * @(#)ItemActivityPriceQueryReqDto.java 1.0 2021/3/9
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 商品活动价格查询dto
 *
 * @author wu.sheng
 * @date 2021/3/9 13:53
 */
@ApiModel(value = "ItemActivityPriceQueryReqDto", description = "商品活动价格查询dto")
public class ItemActivityPriceQueryReqDto extends ItemActivityPriceDto {

    @ApiModelProperty(name = "shopIds", value = "店铺id列表,优先级大于shopId")
    private List<Long> shopIds;

    @ApiModelProperty(name = "itemIds", value = "商品id列表,优先级大于itemId")
    private List<Long> itemIds;

    public List<Long> getShopIds() {
        return shopIds;
    }

    public void setShopIds(List<Long> shopIds) {
        this.shopIds = shopIds;
    }

    public List<Long> getItemIds() {
        return itemIds;
    }

    public void setItemIds(List<Long> itemIds) {
        this.itemIds = itemIds;
    }
}
