/**
 * @(#)ItemActivityTagReqDto.java 1.0 2020/5/19
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 商品活动标签dto
 *
 * @author wu.sheng
 * @date 2020/5/19 10:52
 */
@ApiModel(value = "ItemActivityTagDto", description = "商品活动标签dto")
public class ItemActivityTagDto extends RequestDto {

    @ApiModelProperty(name = "id")
    private String id;

    @ApiModelProperty(name = "itemId", value = "商品id")
    private Long itemId;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "activityTag", value = "活动标签")
    private String activityTag;

    @ApiModelProperty(name = "endTime", value = "活动结束时间")
    private Date endTime;

    @ApiModelProperty(name = "weight", value = "权重")
    private Integer weight;

    @ApiModelProperty(name = "dimension", value = "活动维度：1商品维度，2订单维度，3券维度")
    private Integer dimension;

    @ApiModelProperty(name = "createTime", value = "活动创建时间")
    private Date createTime;

    @ApiModelProperty(name = "preheatStartTime", value = "预热开始时间")
    //@DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date preheatStartTime;

    @ApiModelProperty(name = "shopId", value = "店铺id")
    private Long shopId;

    @ApiModelProperty(name = "display", value = "1显示，0不显示")
    private Integer display;

    @ApiModelProperty(name = "customerId", value = "客户id")
    private Long customerId;

    @ApiModelProperty(name = "srcType", value = "来源类型（1:H5商城，2:PC商城）")
    private Integer srcType = 1;

    public Integer getSrcType() {
        return srcType;
    }

    public void setSrcType(Integer srcType) {
        this.srcType = srcType;
    }

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Long getItemId() {
        return itemId;
    }

    public void setItemId(Long itemId) {
        this.itemId = itemId;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Integer getWeight() {
        return weight;
    }

    public void setWeight(Integer weight) {
        this.weight = weight;
    }

    public Integer getDimension() {
        return dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getPreheatStartTime() {
        return preheatStartTime;
    }

    public void setPreheatStartTime(Date preheatStartTime) {
        this.preheatStartTime = preheatStartTime;
    }

    public Long getShopId() {
        return shopId;
    }

    public void setShopId(Long shopId) {
        this.shopId = shopId;
    }

    public Integer getDisplay() {
        return display;
    }

    public void setDisplay(Integer display) {
        this.display = display;
    }
}
