/**
 * @(#)ItemActivityTagQueryReqDto.java 1.0 2020/5/21
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

@ApiModel(value = "ItemActivityTagQueryReqDto", description = "商品活动标签查询请求dto")
public class ItemActivityTagQueryReqDto extends ItemActivityTagDto {

    @ApiModelProperty(name = "orderByWeight", value = "按权重排序方式：DESC,ASC, 默认DESC")
    private String orderByWeight;

    @ApiModelProperty(name = "dimensionList", value = "多维度查询，优先级高于dimension")
    private List<Integer> dimensionList;

    @ApiModelProperty(name = "itemIdList", value = "多商品id查询，优先级高于单个")
    private List<Long> itemIdList;

    @ApiModelProperty(name = "shopIdList", value = "多店铺id查询，优先级高于单个")
    private List<Long> shopIdList;

    @ApiModelProperty(name = "activityIdList", value = "多活动id查询，优先级高于单个")
    private List<Long> activityIdList;

    public String getOrderByWeight() {
        return orderByWeight;
    }

    public void setOrderByWeight(String orderByWeight) {
        this.orderByWeight = orderByWeight;
    }

    public List<Integer> getDimensionList() {
        return dimensionList;
    }

    public void setDimensionList(List<Integer> dimensionList) {
        this.dimensionList = dimensionList;
    }

    public List<Long> getItemIdList() {
        return itemIdList;
    }

    public void setItemIdList(List<Long> itemIdList) {
        this.itemIdList = itemIdList;
    }

    public List<Long> getActivityIdList() {
        return activityIdList;
    }

    public void setActivityIdList(List<Long> activityIdList) {
        this.activityIdList = activityIdList;
    }

    public List<Long> getShopIdList() {
        return shopIdList;
    }

    public void setShopIdList(List<Long> shopIdList) {
        this.shopIdList = shopIdList;
    }
}
