/*
 * @(#)OrderStatusChangeOrderDetailDto.java 1.0 2021-01-22
 *
 * Copyright (c) 2021, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

/**
 * 订单状态变更的订单详情
 *
 * @author 简树
 * @since 2.0.0
 */
public class OrderStatusChangeOrderDetailDto extends RequestDto {
    public final static String ORDER_STATUS_CHANGE_TAG = "ORDER_STATUS_CHANGE_TAG";
    /**
     * 订单取消
     */
    public final static String CANCEL = "CANCEL";
    /**
     * 订单关闭
     */
    public final static String CLOSE = "CLOSE";
    /**
     * 订单支付成功
     */
    public final static String PAYED = "PAYED";
    /**
     * 订单发货
     */
    public final static String WAIT_DELIVERY = "WAIT_DELIVERY";
    /**
     * 订单完成
     */
    public final static String COMPLETE = "COMPLETE";
    /**
     * 秒杀订单
     */
    public final static String SECKILL_ORDER= "3";
    /**
     * 拼团订单
     */
    public final static String GROUP_ORDER= "2";
    /**
     * 优惠券活动
     */
    public final static Integer COUPON_ACTIVITY = 2;
    /**
     * 秒杀活动
     */
    public final static Integer SECKILL_ACTIVITY = 3;
    /**
     * 促销活动
     */
    public final static Integer PROMOTION = 4;
    /**
     * 限时折扣活动
     */
    public final static Integer TIME_DISCOUNT = 6;
    /**
     * 组团活动
     */
    public final static int GROUP_ACTIVITY = 1;
    @ApiModelProperty(name = "bizType", value = "订单业务类型：默认normal，应用自定义。")
    private String bizType;
    /**
     * 引擎信息,旧的逻辑遗留问题，不能一时更改
     */
    private EngineParams engineParams;
    /**
     * 订单状态
     */
    private String orderTradeStatus;
    /**
     * 订单号
     */
    private String orderCode;
    private Long userId;
    /**
     * 客户id,标识为B端订单
     */
    private Long customerId;
    /**
     * 此订单是否存在活动库存 false：否；true:是
     */
    private Boolean activityFlag = false;
    /**
     * 订单列表
     */
    private List<TradeItem> orderItems;
    private List<OrderActivityInfoReqDto> activitys;

    public Long getCustomerId() {
        return customerId;
    }

    public void setCustomerId(Long customerId) {
        this.customerId = customerId;
    }

    public Boolean getActivityFlag() {
        return activityFlag;
    }

    public void setActivityFlag(Boolean activityFlag) {
        this.activityFlag = activityFlag;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public List<OrderActivityInfoReqDto> getActivitys() {
        return activitys;
    }

    public void setActivitys(List<OrderActivityInfoReqDto> activitys) {
        this.activitys = activitys;
    }

    public String getBizType() {
        return bizType;
    }

    public void setBizType(String bizType) {
        this.bizType = bizType;
    }

    public List<TradeItem> getOrderItems() {
        return orderItems;
    }

    public void setOrderItems(List<TradeItem> orderItems) {
        this.orderItems = orderItems;
    }

    public EngineParams getEngineParams() {
        return engineParams;
    }

    public void setEngineParams(EngineParams engineParams) {
        this.engineParams = engineParams;
    }

    public String getOrderTradeStatus() {
        return orderTradeStatus;
    }

    public void setOrderTradeStatus(String orderTradeStatus) {
        this.orderTradeStatus = orderTradeStatus;
    }

    public String getOrderCode() {
        return orderCode;
    }

    public void setOrderCode(String orderCode) {
        this.orderCode = orderCode;
    }


    public static class TradeItem implements Serializable {
        @ApiModelProperty(name = "id", value = "id")
        private Long id;
        /**
         * 交易商品流水号
         * 业务唯一记录
         */
        @ApiModelProperty(name = "tradeItemNo", value = "交易商品流水号业务唯一记录")
        private String tradeItemNo;
        /**
         * 商品类型: 7
         */
        @ApiModelProperty(name = "itemType", value = "订单商品类型: 1 普通 2 产品 3 组合 4 虚拟")
        private Integer itemType;

        /**
         * 商品业务类型
         */
        @ApiModelProperty(name = "busType", value = "商品业务类型,默认0")
        private Integer busType = 0;
        /**
         * 商品ID
         */
        @ApiModelProperty(name = "itemSerial", value = "商品ID")
        private String itemSerial;

        /**
         * skuID
         * 库存规格ID
         */
        @ApiModelProperty(name = "skuSerial", value = "skuID库存规格ID")
        private String skuSerial;
        /**
         * 商品数量
         */
        @ApiModelProperty(name = "itemNum", value = "商品数量")
        @NotNull(message = "itemNum不能为空")
        private Integer itemNum;

        @ApiModelProperty(name = "shopId", value = "店铺id")
        private String shopId;

        /**
         * 商品应付总金额
         */
        @ApiModelProperty(name = "payOrigTotalAmount", value = "商品应付总金额")
        private BigDecimal payOrigTotalAmount;

        public Long getId() {
            return id;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public String getTradeItemNo() {
            return tradeItemNo;
        }

        public void setTradeItemNo(String tradeItemNo) {
            this.tradeItemNo = tradeItemNo;
        }

        public Integer getItemType() {
            return itemType;
        }

        public void setItemType(Integer itemType) {
            this.itemType = itemType;
        }

        public Integer getBusType() {
            return busType;
        }

        public void setBusType(Integer busType) {
            this.busType = busType;
        }

        public String getItemSerial() {
            return itemSerial;
        }

        public void setItemSerial(String itemSerial) {
            this.itemSerial = itemSerial;
        }

        public String getSkuSerial() {
            return skuSerial;
        }

        public void setSkuSerial(String skuSerial) {
            this.skuSerial = skuSerial;
        }

        public Integer getItemNum() {
            return itemNum;
        }

        public void setItemNum(Integer itemNum) {
            this.itemNum = itemNum;
        }

        public String getShopId() {
            return shopId;
        }

        public void setShopId(String shopId) {
            this.shopId = shopId;
        }

        public BigDecimal getPayOrigTotalAmount() {
            return payOrigTotalAmount;
        }

        public void setPayOrigTotalAmount(BigDecimal payOrigTotalAmount) {
            this.payOrigTotalAmount = payOrigTotalAmount;
        }
    }

    public static class OrderActivityInfoReqDto implements Serializable {
        @ApiModelProperty(name = "type", value = "活动类型：1 拼团活动  2优惠券活动")
        private Integer type;

        @ApiModelProperty(name = "activityId", value = "活动id")
        private Long activityId;
        @ApiModelProperty(name = "activityItemIds", value = "活动明细id列表，优惠券活动关联优惠券id")
        private List<String> activityItemIds;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public Long getActivityId() {
            return activityId;
        }

        public void setActivityId(Long activityId) {
            this.activityId = activityId;
        }

        public List<String> getActivityItemIds() {
            return activityItemIds;
        }

        public void setActivityItemIds(List<String> activityItemIds) {
            this.activityItemIds = activityItemIds;
        }
    }


}