/**
 * @(#) ActivityTemplateReqDto.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 规则模版查询请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "RuleQueryReqDto", description = "规则模版查询请求Dto")
public class RuleQueryReqDto extends RequestDto {

    private static final long serialVersionUID = 7545043522171500009L;
    /**
     * 规则名称
     */
    @ApiModelProperty(name = "ruleName", value = "规则名称")
    private String ruleName;

    /**
     * 描述
     */
    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    /**
     * 状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "ruleStatus", value = "状态（ENABLE：启用、DISABLE：停用）")
    private EnableStatusEnum ruleStatusEnum;
    /**
     * 规则编号
     */
    @ApiModelProperty(name = "id", value = "规则编号")
    private Long id;
    /**
     * 创建起始时间
     */
    @ApiModelProperty(name = "createStartTime", value = "创建起始时间")
    private String createStartTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;


    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EnableStatusEnum getRuleStatusEnum() {
        return ruleStatusEnum;
    }

    public void setRuleStatusEnum(EnableStatusEnum ruleStatusEnum) {
        this.ruleStatusEnum = ruleStatusEnum;
    }

    public String getCreateStartTime() {
        return createStartTime;
    }

    public void setCreateStartTime(String createStartTime) {
        this.createStartTime = createStartTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }


}
