package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums.EnableStatusEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Set;

/**
 * 规则
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "RuleReqDto", description = "规则请求Dto")
public class RuleReqDto extends RequestDto {
    /**
     * 规则名称
     */
    @ApiModelProperty(name = "ruleName", value = "规则名称")
    private String ruleName;

    /**
     * 描述
     */
    @ApiModelProperty(name = "description", value = "描述")
    private String description;

    /**
     * 状态（ENABLE：启用、DISABLE：停用）
     */
    @ApiModelProperty(name = "ruleStatus", value = "状态（ENABLE：启用、DISABLE：停用）")
    private EnableStatusEnum ruleStatusEnum;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;


    private Set<Long> conditionTemplateIds ;

    public Set<Long> getConditionTemplateIds() {
        return conditionTemplateIds;
    }

    public void setConditionTemplateIds(Set<Long> conditionTemplateIds) {
        this.conditionTemplateIds = conditionTemplateIds;
    }

    public String getRuleName() {
        return ruleName;
    }

    public void setRuleName(String ruleName) {
        this.ruleName = ruleName;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EnableStatusEnum getRuleStatusEnum() {
        return ruleStatusEnum;
    }

    public void setRuleStatusEnum(EnableStatusEnum ruleStatusEnum) {
        this.ruleStatusEnum = ruleStatusEnum;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
