/**
 * @(#) ActivityTemplateReqDto.java 1.0 2018-10-19
 * Copyright (c) 2018, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 活动模版查询请求Dto
 *
 * @author 魄罗
 * @since 2.0.0
 */
@ApiModel(value = "TriggerQueryReqDto", description = "触发器查询请求Dto")
public class TriggerQueryReqDto extends RequestDto {

    private static final long serialVersionUID = -2125405506684398683L;
    /**
     * 触发器编号
     */
    @ApiModelProperty(name = "id", value = "触发器编号")
    private Long id;
    /**
     *  规则触发表达式
     */
    @ApiModelProperty(name = "triggerExpression", value = "规则触发表达式")
    private String triggerExpression;

    /**
     *  策略编号
     */
    @ApiModelProperty(name = "policyId", value = "策略编号")
    private Long policyId;
    /**
     * 创建起始时间
     */
    @ApiModelProperty(name = "createStartTime", value = "创建起始时间")
    private String createStartTime;
    /**
     * 创建结束时间
     */
    @ApiModelProperty(name = "createEndTime", value = "创建结束时间")
    private String createEndTime;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTriggerExpression() {
        return triggerExpression;
    }

    public void setTriggerExpression(String triggerExpression) {
        this.triggerExpression = triggerExpression;
    }

    public Long getPolicyId() {
        return policyId;
    }

    public void setPolicyId(Long policyId) {
        this.policyId = policyId;
    }

    public String getCreateStartTime() {
        return createStartTime;
    }

    public void setCreateStartTime(String createStartTime) {
        this.createStartTime = createStartTime;
    }

    public String getCreateEndTime() {
        return createEndTime;
    }

    public void setCreateEndTime(String createEndTime) {
        this.createEndTime = createEndTime;
    }


}
