package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.validation.constraints.NotNull;
import java.util.Set;

/**
 * 触发器
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "DavinciTriggerReqDto", description = "触发器请求Dto")
public class TriggerReqDto extends RequestDto {

    private static final long serialVersionUID = 2095791961197647319L;
    /**
     * 规则触发表达式
     */
    @ApiModelProperty(name = "triggerExpression", value = "规则触发表达式( 规则ID加逻辑表达式【|&()】例如【1&(2|3)&4】 )")
    private String triggerExpression;

    /**
     * 策略编号
     */
    @ApiModelProperty(name = "policyId", value = "策略编号")
    @NotNull(message = "策略ID不能为空")
    private Long policyId;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;

    private Set<Long> actionTemplateIds ;

    public Set<Long> getActionTemplateIds() {
        return actionTemplateIds;
    }

    public void setActionTemplateIds(Set<Long> actionTemplateIds) {
        this.actionTemplateIds = actionTemplateIds;
    }

    public String getTriggerExpression() {
        return triggerExpression;
    }

    public void setTriggerExpression(String triggerExpression) {
        this.triggerExpression = triggerExpression;
    }

    public Long getPolicyId() {
        return policyId;
    }

    public void setPolicyId(Long policyId) {
        this.policyId = policyId;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
