package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 动作模板
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "ActionTemplateRespDto", description = "动作模板Dto")
public class ActionTemplateRespDto extends RequestDto {

    private static final long serialVersionUID = 7187622912891553899L;
    @ApiModelProperty(name = "id", value = "动作规则模板编号")
    private Long id;

    /**
     * 策略名称
     */
    @ApiModelProperty(name = "templateName", value = "模板名称")
    private String templateName;

    /**
     * 动作模板定义
     */
    @ApiModelProperty(name = "actionDefine", value = "动作模板定义")
    private String actionDefine;

    /**
     * 解析脚本
     */
    @ApiModelProperty(name = "scripts", value = "解析脚本")
    private String scripts;

    /**
     * 脚本解析方式（PREPARE：预编译、RUNTIME：运行时）
     */
    @ApiModelProperty(name = "scriptsType", value = "脚本解析方式（PREPARE：预编译、RUNTIME：运行时）")
    private String scriptsType;

    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;

    /**
     * 特殊查询
     */
    private Long triggerId ;


    public Long getTriggerId() {
        return triggerId;
    }

    public void setTriggerId(Long triggerId) {
        this.triggerId = triggerId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getActionDefine() {
        return actionDefine;
    }

    public void setActionDefine(String actionDefine) {
        this.actionDefine = actionDefine;
    }

    public String getScripts() {
        return scripts;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }

    public String getScriptsType() {
        return scriptsType;
    }

    public void setScriptsType(String scriptsType) {
        this.scriptsType = scriptsType;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }
}
