/*
 * *
 *  * @(#)GiftReqDto.java 2.0.0 18-10-10 上午11:12
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.CommonVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

/**
 * 活动商品响应dto
 * 
 * @author luo.lei
 * @since 2.0.0
 */
@ApiModel(value = "ActivityItemRespDto", description = "活动商品响应dto")
public class ActivityItemRespDto extends CommonVo {

	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@ApiModelProperty(name = "id", value = "id")
	private Long id;

	/**
	 * 商品类型（ITEM：商品、GIFT：赠品）
	 */
	@ApiModelProperty(name = "itemType", value = "商品类型（ITEM：商品、GIFT：赠品）")
	private String itemType;
	/**
	 * 商品ID
	 */
	@ApiModelProperty(name = "itemId", value = "商品ID")
	private Long itemId;
	/**
	 * sku_id
	 */
	@ApiModelProperty(name = "skuId", value = "sku_id")
	private Long skuId;
	/**
	 * 商品名称
	 */
	@ApiModelProperty(name = "itemName", value = "商品名称")
	private String itemName;
	/**
	 * 图片
	 */
	@ApiModelProperty(name = "picture", value = "图片")
	private String picture;
	/**
	 * 税率
	 */
	@ApiModelProperty(name = "taxRate", value = "税率")
	private Float taxRate;
	/**
	 * 商品分类编码
	 */
	@ApiModelProperty(name = "categoryCode", value = "商品分类编码")
	private String categoryCode;
	/**
	 * 赠送数量
	 */
	@ApiModelProperty(name = "attachNum", value = "赠送数量")
	private Integer attachNum;

	/**
	 * 活动库存
	 */
	@ApiModelProperty(name = "originalStock", value = "活动库存")
	private Long originalStock;
	/**
	 * 剩余库存
	 */
	@ApiModelProperty(name = "remainingStock", value = "剩余库存")
	private Long remainingStock;
	/**
	 * 剩余参与次数
	 * 活动库存扣减时，如果商品shopId+skuId参与了多个活动，则每个活动的剩余参与次数依次扣减，
	 * 但是只选取其中一个活动扣减剩余活动库存，已保持数据的一致性
	 */
	@ApiModelProperty(name = "activityStock", value = "剩余参与次数")
	private Long activityStock;
	/**
	 * 活动ID
	 */
	@ApiModelProperty(name = "activityId", value = "活动ID")
	private Long activityId;

	/**
	 * 活动价格（单位：元）
	 */
	@ApiModelProperty(name = "activityPrice", value = "活动价格")
	private BigDecimal activityPrice;
	/**
	 * 活动PV
	 */
	@ApiModelProperty(name = "activityPv", value = "活动PV")
	private Long activityPv;
	/**
	 * 状态（NEW：新增、ENABLED：启用、DIABLED：禁用）
	 */
	@ApiModelProperty(name = "status", value = "状态（NEW：新增、ENABLED：启用、DIABLED：禁用）")
	private String status;

	/**
	 * 实例ID
	 */
	@ApiModelProperty(name = "instanceId", value = "实例ID")
	private Long instanceId;
	/**
	 * 租户ID
	 */
	@ApiModelProperty(name = "tenantId", value = "租户ID")
	private Long tenantId;

	/**
	 * 店铺id
	 */
	@ApiModelProperty(name = "shopId", value = "店铺id")
	private Long shopId;

	public Long getActivityStock() {
		return activityStock;
	}

	public void setActivityStock(Long activityStock) {
		this.activityStock = activityStock;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public String getItemType() {
		return itemType;
	}

	public void setItemType(String itemType) {
		this.itemType = itemType;
	}

	public Long getItemId() {
		return itemId;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getSkuId() {
		return skuId;
	}

	public void setSkuId(Long skuId) {
		this.skuId = skuId;
	}

	public String getItemName() {
		return itemName;
	}

	public void setItemName(String itemName) {
		this.itemName = itemName;
	}

	public String getPicture() {
		return picture;
	}

	public void setPicture(String picture) {
		this.picture = picture;
	}

	public Float getTaxRate() {
		return taxRate;
	}

	public void setTaxRate(Float taxRate) {
		this.taxRate = taxRate;
	}

	public String getCategoryCode() {
		return categoryCode;
	}

	public void setCategoryCode(String categoryCode) {
		this.categoryCode = categoryCode;
	}

	public Integer getAttachNum() {
		return attachNum;
	}

	public void setAttachNum(Integer attachNum) {
		this.attachNum = attachNum;
	}

	public Long getOriginalStock() {
		return originalStock;
	}

	public void setOriginalStock(Long originalStock) {
		this.originalStock = originalStock;
	}

	public Long getRemainingStock() {
		return remainingStock;
	}

	public void setRemainingStock(Long remainingStock) {
		this.remainingStock = remainingStock;
	}

	public Long getActivityId() {
		return activityId;
	}

	public void setActivityId(Long activityId) {
		this.activityId = activityId;
	}

	public BigDecimal getActivityPrice() {
		return activityPrice;
	}

	public void setActivityPrice(BigDecimal activityPrice) {
		this.activityPrice = activityPrice;
	}

	public Long getActivityPv() {
		return activityPv;
	}

	public void setActivityPv(Long activityPv) {
		this.activityPv = activityPv;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}

	public Long getShopId() {
		return shopId;
	}

	public void setShopId(Long shopId) {
		this.shopId = shopId;
	}
}
