/**
 * @(#)ActivityRelationRespDto.java 1.0 2021/3/11
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Date;

/**
 * 活动关系扩展响应dto
 *
 * @author wu.sheng
 * @date 2021/3/11 10:58
 */
@ApiModel(value = "ActivityRelationExtRespDto", description = "活动关系扩展响应dto")
public class ActivityRelationExtRespDto extends ActivityRelationRespDto {

    /**
     * 目标活动编号
     */
    @ApiModelProperty(name = "activityCode", value = "目标活动编号")
    private String activityCode;

    /**
     * 目标活动名称
     */
    @ApiModelProperty(name = "activityName", value = "目标活动名称")
    private String activityName;

    /**
     * 目标活动开始时间
     */
    @ApiModelProperty(name = "beginTime", value = "目标活动开始时间")
    private Date beginTime;

    /**
     * 目标活动结束时间
     */
    @ApiModelProperty(name = "endTime", value = "目标活动结束时间")
    private Date endTime;

    /**
     * 目标活动状态
     */
    @ApiModelProperty(name = "activityStatus", value = "目标活动状态")
    private String activityStatus;

    /**
     * 目标活动id
     */
    @ApiModelProperty(name = "targetActivityId", value = "目标活动id")
    private Long targetActivityId;

    /**
     * 目标活动审核状态
     */
    @ApiModelProperty(name = "auditStatus", value = "目标活动审核状态")
    private String auditStatus;

    public String getAuditStatus() {
        return auditStatus;
    }

    public void setAuditStatus(String auditStatus) {
        this.auditStatus = auditStatus;
    }

    public Long getTargetActivityId() {
        return targetActivityId;
    }

    public void setTargetActivityId(Long targetActivityId) {
        this.targetActivityId = targetActivityId;
    }

    public String getActivityCode() {
        return activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityName() {
        return activityName;
    }

    public void setActivityName(String activityName) {
        this.activityName = activityName;
    }

    public Date getBeginTime() {
        return beginTime;
    }

    public void setBeginTime(Date beginTime) {
        this.beginTime = beginTime;
    }

    public Date getEndTime() {
        return endTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public String getActivityStatus() {
        return activityStatus;
    }

    public void setActivityStatus(String activityStatus) {
        this.activityStatus = activityStatus;
    }
}
