/**
 * @(#)ActivityRelationRespDto.java 1.0 2021/3/11
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 商品关系响应dto
 *
 * @author wu.sheng
 * @date 2021/3/11 10:58
 */
@ApiModel(value = "ActivityRelationRespDto", description = "商品关系响应dto")
public class ActivityRelationRespDto extends BaseVo {

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "bizId", value = "业务id")
    private Long bizId;

    /**
     * 源活动模板id
     */
    @ApiModelProperty(name = "sourceTemplateId", value = "源活动模板id")
    private Long sourceTemplateId;

    /**
     * 目标活动模板id
     */
    @ApiModelProperty(name = "targetTemplateId", value = "目标活动模板id")
    private Long targetTemplateId;

    /**
     * 关系：0互斥，1叠加
     */
    @ApiModelProperty(name = "relation", value = "关系：1叠加，0互斥")
    private Integer relation;

    @ApiModelProperty(name = "targetTemplateName", value = "目标活动模板名称")
    private String targetTemplateName;

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getSourceTemplateId() {
        return sourceTemplateId;
    }

    public void setSourceTemplateId(Long sourceTemplateId) {
        this.sourceTemplateId = sourceTemplateId;
    }

    public Long getTargetTemplateId() {
        return targetTemplateId;
    }

    public void setTargetTemplateId(Long targetTemplateId) {
        this.targetTemplateId = targetTemplateId;
    }

    public Integer getRelation() {
        return relation;
    }

    public void setRelation(Integer relation) {
        this.relation = relation;
    }

    public Long getBizId() {
        return bizId;
    }

    public void setBizId(Long bizId) {
        this.bizId = bizId;
    }

    public String getTargetTemplateName() {
        return targetTemplateName;
    }

    public void setTargetTemplateName(String targetTemplateName) {
        this.targetTemplateName = targetTemplateName;
    }
}
