package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.dto.RequestDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 条件模板
 *
 * @author tuyun
 * @since 2.0.0
 */
@ApiModel(value = "ConditionTemplateRespDto", description = "条件模板Dto")
public class ConditionTemplateRespDto extends RequestDto {

    private static final long serialVersionUID = -7118584823557188628L;
    @ApiModelProperty(name = "id", value = "条件规则模板编号")
    private Long id;

    /**
     * 策略名称
     */
    @ApiModelProperty(name = "templateName", value = "模板名称")
    private String templateName;

    /**
     * 条件模板定义
     */
    @ApiModelProperty(name = "conditionDefine", value = "条件模板定义")
    private String conditionDefine;

    /**
     * 解析脚本
     */
    @ApiModelProperty(name = "scripts", value = "解析脚本")
    private String scripts;

    /**
     * 脚本解析方式（PREPARE：预编译、RUNTIME：运行时）
     */
    @ApiModelProperty(name = "scriptsType", value = "脚本解析方式（PREPARE：预编译、RUNTIME：运行时）")
    private String scriptsType;


    /**
     * 扩展字段，存放json
     */
    @ApiModelProperty(name = "extension", value = "扩展字段，存放json")
    private String extension;

    /**
     * 除非你明确知道该字段有值，否则不要使用该字段 特殊逻辑业务
     */
    private Long ruleId;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTemplateName() {
        return templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getConditionDefine() {
        return conditionDefine;
    }

    public void setConditionDefine(String conditionDefine) {
        this.conditionDefine = conditionDefine;
    }

    public String getScripts() {
        return scripts;
    }

    public void setScripts(String scripts) {
        this.scripts = scripts;
    }

    public String getScriptsType() {
        return scriptsType;
    }

    public void setScriptsType(String scriptsType) {
        this.scriptsType = scriptsType;
    }

    public String getExtension() {
        return extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public Long getRuleId() {
        return ruleId;
    }

    public void setRuleId(Long ruleId) {
        this.ruleId = ruleId;
    }
}
