package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.vo.BaseVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.math.BigDecimal;

@ApiModel(value = "ExchangeDisplayRespDto",description = "购物车参与换购活动展示dto")
public class ExchangeActivityRespDto extends BaseVo {
    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "activityTag", value = "活动标签")
    private Long activityTag;

    @ApiModelProperty(name = "unit", value = "门槛单位: 1 元，2 件")
    private Integer unit;

    @ApiModelProperty(name = "targetValue", value = "当前活动商品门槛值")
    private BigDecimal targetValue;

    @ApiModelProperty(name = "threshold", value = "已满足门槛值")
    private BigDecimal threshold;

    @ApiModelProperty(name = "nextThreshold", value = "下一门槛金额")
    private BigDecimal nextThreshold;

    @ApiModelProperty(name = "discount", value = "换购额度")
    private BigDecimal discount;

    @ApiModelProperty(name = "nextDiscount", value = "下一级换购额度")
    private BigDecimal nextDiscount;

    /**
     * 换购方式 0任意消费(免费换购)，1指定消费门槛(加价换购)
     */
    @ApiModelProperty(name = "thresholdType", value = "换购方式 0任意消费(免费换购)，1指定消费门槛(加价换购)")
    private Integer thresholdType;

    /**
     * 促销条件： 1 阶梯，2 每满，3 满
     */
    @ApiModelProperty(name = "promotionCondition", value = "促销条件： 1 阶梯，2 每满，3 满")
    private Integer promotionCondition;

    /**
     * 额度类型: 1 元，2 件
     */
    @ApiModelProperty(name = "discountUnit", value = "赠送额度类型: 1 元，2 件")
    private Integer discountUnit;

    /**
     * 额度类型: 1 元，2 件
     */
    @ApiModelProperty(name = "nextDiscountUnit", value = "下一阶梯赠送额度类型: 1 元，2 件")
    private Integer nextDiscountUnit;

    /**
     * 额度比例: 1 固定值，2 商品金额比例
     */
    @ApiModelProperty(name = "nexDiscountScale", value = "额度比例: 1 固定值，2 商品金额比例")
    private Integer nexDiscountScale;

    @ApiModelProperty(name = "clearExchangeItem", value = "是否清除换购商品,0 不清除，1，清除，默认为0")
    private Integer clearExchangeItem = 0;

    @ApiModelProperty(name = "accountAvailableBalance", value = "当前账户可用额度")
    private BigDecimal accountAvailableBalance;

    @ApiModelProperty(name = "inited", value = "是否已创建账户，true-已创建，false-未创建")
    private boolean inited;

    @ApiModelProperty(name = "ifBalanceAccount", value = "是否额度累积：0 否 1 是")
    private Integer ifBalanceAccount;

    public Integer getIfBalanceAccount() {
        return ifBalanceAccount;
    }

    public void setIfBalanceAccount(Integer ifBalanceAccount) {
        this.ifBalanceAccount = ifBalanceAccount;
    }

    public boolean isInited() {
        return inited;
    }

    public void setInited(boolean inited) {
        this.inited = inited;
    }

    public BigDecimal getAccountAvailableBalance() {
        return accountAvailableBalance;
    }

    public void setAccountAvailableBalance(BigDecimal accountAvailableBalance) {
        this.accountAvailableBalance = accountAvailableBalance;
    }

    public Integer getNexDiscountScale() {
        return nexDiscountScale;
    }

    public void setNexDiscountScale(Integer nexDiscountScale) {
        this.nexDiscountScale = nexDiscountScale;
    }

    public Integer getClearExchangeItem() {
        return clearExchangeItem;
    }

    public void setClearExchangeItem(Integer clearExchangeItem) {
        this.clearExchangeItem = clearExchangeItem;
    }

    public Integer getNextDiscountUnit() {
        return nextDiscountUnit;
    }

    public void setNextDiscountUnit(Integer nextDiscountUnit) {
        this.nextDiscountUnit = nextDiscountUnit;
    }

    public Integer getDiscountUnit() {
        return discountUnit;
    }

    public void setDiscountUnit(Integer discountUnit) {
        this.discountUnit = discountUnit;
    }

    public Integer getThresholdType() {
        return thresholdType;
    }

    public void setThresholdType(Integer thresholdType) {
        this.thresholdType = thresholdType;
    }

    public Integer getPromotionCondition() {
        return promotionCondition;
    }

    public void setPromotionCondition(Integer promotionCondition) {
        this.promotionCondition = promotionCondition;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public Long getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(Long activityTag) {
        this.activityTag = activityTag;
    }

    public Integer getUnit() {
        return unit;
    }

    public void setUnit(Integer unit) {
        this.unit = unit;
    }

    public BigDecimal getTargetValue() {
        return targetValue;
    }

    public void setTargetValue(BigDecimal targetValue) {
        this.targetValue = targetValue;
    }

    public BigDecimal getThreshold() {
        return threshold;
    }

    public void setThreshold(BigDecimal threshold) {
        this.threshold = threshold;
    }

    public BigDecimal getNextThreshold() {
        return nextThreshold;
    }

    public void setNextThreshold(BigDecimal nextThreshold) {
        this.nextThreshold = nextThreshold;
    }

    public BigDecimal getDiscount() {
        return discount;
    }

    public void setDiscount(BigDecimal discount) {
        this.discount = discount;
    }

    public BigDecimal getNextDiscount() {
        return nextDiscount;
    }

    public void setNextDiscount(BigDecimal nextDiscount) {
        this.nextDiscount = nextDiscount;
    }
}
