/**
 * @(#)PromotionActivityRespDto.java 1.0 2021/3/31
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 促销活动
 *
 * @author wu.sheng
 * @date 2021/3/31 15:42
 */
@ApiModel(value = "PromotionActivityRespDto", description = "促销活动预览响应dto")
public class PromotionActivityRespDto extends ActivityRespDto {

    @ApiModelProperty(name = "shopList", value = "活动适用的店铺id列表")
    private List<Long> shopList;

    @ApiModelProperty(name = "status", value = "状态：1可用，0不可用")
    private Integer status;

    @ApiModelProperty(name = "activityId", value = "活动id")
    private Long activityId;

    @ApiModelProperty(name = "unableReason", value = "不可用原因")
    private String unableReason;

    @ApiModelProperty(name = "shopSkuList", value = "活动适用的店铺id加SKUid列表(shopId_skuId)")
    private List<String> shopSkuList;

    public List<String> getShopSkuList() {
        return shopSkuList;
    }

    public void setShopSkuList(List<String> shopSkuList) {
        this.shopSkuList = shopSkuList;
    }

    public List<Long> getShopList() {
        return shopList;
    }

    public void setShopList(List<Long> shopList) {
        this.shopList = shopList;
    }

    public Integer getStatus() {
        return status;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getUnableReason() {
        return unableReason;
    }

    public void setUnableReason(String unableReason) {
        this.unableReason = unableReason;
    }
}
