/**
 * @(#)PromotionActivityRespDto.java 1.0 2021/3/31
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.response;

import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.ActivityRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.coupon.dto.response.SimpleCouponRespDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.List;

/**
 * 促销活动和优惠券响应
 *
 * @author wu.sheng
 * @date 2021/3/31 15:42
 */
@ApiModel(value = "PromotionCouponRespDto", description = "促销活动和优惠券响应dto")
public class PromotionCouponRespDto {

    @ApiModelProperty(name = "promotionActivityIds", value = "促销活动id列表")
    private List<Long> promotionActivityIds;

    @ApiModelProperty(name = "activityRespDtos", value = "促销活动列表")
    private List<ActivityRespDto> activityRespDtos;

    @ApiModelProperty(name = "couponList", value = "优惠券列表")
    private List<SimpleCouponRespDto> couponList;

    public List<ActivityRespDto> getActivityRespDtos() {
        return activityRespDtos;
    }

    public void setActivityRespDtos(List<ActivityRespDto> activityRespDtos) {
        this.activityRespDtos = activityRespDtos;
    }

    public List<Long> getPromotionActivityIds() {
        return promotionActivityIds;
    }

    public void setPromotionActivityIds(List<Long> promotionActivityIds) {
        this.promotionActivityIds = promotionActivityIds;
    }

    public List<SimpleCouponRespDto> getCouponList() {
        return couponList;
    }

    public void setCouponList(List<SimpleCouponRespDto> couponList) {
        this.couponList = couponList;
    }
}
