/*
 * *
 *  * @(#)ActivityStatusEnum.java 2.0.0 18-12-11 下午4:37
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums;

/**
 * @author luo.lei
 * @since 2.0.0
 */
public enum ActivityStatusEnum {
    /**
     * 活动状态枚举
     */
    NEW("NEW", "新建"),
    READY("READY", "就绪"),
    DISABLE("DISABLE", "禁用"),
    ACTIVATE("ACTIVATE", "活动中"),
    PAUSE("PAUSE", "暂停"),
    FINISHING("FINISHING", "结束中"),
    FINISH("FINISH", "活动结束"),
    ERROR_FINISH("ERROR_FINISH", "异常结束");
    private String key;

    private String value;

    ActivityStatusEnum(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public static ActivityStatusEnum getByKey(String key) {
        for (ActivityStatusEnum statusEnum : ActivityStatusEnum.values()) {
            if (key.equals(statusEnum.getKey())) {
                return statusEnum;
            }
        }
        return null;
    }

    public String getKey() {
        return key;
    }

    public String getValue() {
        return value;
    }

}
