/*
 * *
 *  * @(#)ActivityType.java 2.0.0 7/11/19 9:59 AM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums;

import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

/**
 * @author luo.lei
 */
public enum ActivityType {
    // 满折活动
    @ApiModelProperty("满折活动")
    FULL_DISCOUNT_ACTIVITY(1197154895685446734L),
    // 满减活动
    @ApiModelProperty("满减活动")
    OVERALL_REDUCTION_ACTIVITY(1197154895685446735L),
    // 满返活动
    @ApiModelProperty("满返活动")
    FULL_RETURNING_ACTIVITY(1197154895685446736L),
    // 满赠活动
    @ApiModelProperty("满赠满返活动")
    FULL_PRESENT_ACTIVITY(1197154895685446737L),
    // 加价购活动
    @ApiModelProperty("加价购活动")
    ADDITIONAL_PURCHASE_ACTIVITY(1197154895685446738L),
    // 储值赠礼
    @ApiModelProperty("储值赠礼")
    DEPOSIT_PRESENT_ACTIVITY(1197154895685446739L),
    // 积分兑换
    @ApiModelProperty("积分兑换")
    INTEGRAL_EXCHANGE_ACTIVITY(1197154895685446740L),

    @ApiModelProperty("优惠券活动")
    COUPON_ACTIVITY(1221775335858830395L),

    @ApiModelProperty("拼团活动")
    GROUP_ACTIVITY(1221775335858830396L),

    @ApiModelProperty("限时折扣活动")
    TIME_DISCOUNT_ACTIVITY(1221775335858830397L),

    @ApiModelProperty("满减满折活动")
    FULL_REDUCTION_ACTIVITY(1221775335858830398L),

    @ApiModelProperty("秒杀活动")
    SECKILL_ACTIVITY(1221775335858830399L),

    @ApiModelProperty("买送活动")
    BUY_GIVE_ACTIVITY(1221775335858830560L),

    // 满赠活动
    @ApiModelProperty("TOB满赠活动")
    FULL_PRESENT_TOB_ACTIVITY(5197154895685446737L),

    // 满减活动
    @ApiModelProperty("TOB满减活动")
    OVERALL_REDUCTION_TOB_ACTIVITY(5197154895685446735L),

    // 满折活动
    @ApiModelProperty("TOB满折活动")
    FULL_DISCOUNT_TOB_ACTIVITY(5197154895685446734L),

    @ApiModelProperty("TOB限时特价活动")
    TIME_DISCOUNT_TOB_ACTIVITY(5221775335858830397L),

    @ApiModelProperty("TOB限时抢购活动")
    SECKILL_TOB_ACTIVITY(5221775335858830399L),

    @ApiModelProperty("TOB平台优惠券活动")
    COUPON_TOB_ACTIVITY(5221775335858830395L),

    @ApiModelProperty("换购活动")
    EXCHANGE_ACTIVITY(1221775335858830402L),

    @ApiModelProperty("优惠套餐活动")
    COMBINATION_ACTIVITY(1221775335858830411L),

    ;

    long id;

    ActivityType(long id) {
        this.id = id;
    }


    public long getId() {
        return id;
    }

    public static ActivityType getByType(Long id) {
        for (ActivityType typeValue : values()) {
            if (Objects.equals(id, typeValue.getId())) {
                return typeValue;
            }
        }
        return null;
    }

    /**
     * 通过枚举名称获取简写形式   例如：DISCOUNT_ACTIVITY 得到 DA
     *
     * @return 简写
     */
    public StringBuilder acronym() {
        String[] temp = this.toString().split("_");
        StringBuilder sb = new StringBuilder();
        for (String s : temp) {
            sb.append(s.charAt(0));
        }
        return sb;
    }
}