/**
 * @(#)BizActivityType.java 1.0 2021/3/15
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.util.Objects;

@ApiModel(value = "BizActivityType", description = "活动业务类型，判断互斥使用")
public enum BizActivityType {

    // 满返活动
    @ApiModelProperty("满返活动")
    FULL_RETURNING_ACTIVITY(1197154895685446736L, "满返"),

    @ApiModelProperty("满赠满返活动")
    FULL_PRESENT_ACTIVITY(1197154895685446737L, "满赠满返"),

    @ApiModelProperty("优惠券活动")
    COUPON_ACTIVITY(1221775335858830395L, "平台优惠券"),

    @ApiModelProperty("拼团活动")
    GROUP_ACTIVITY(1221775335858830396L, "多人拼团"),

    @ApiModelProperty("限时折扣活动")
    TIME_DISCOUNT_ACTIVITY(1221775335858830397L, "限时折扣"),

    @ApiModelProperty("满减满折活动")
    FULL_REDUCTION_ACTIVITY(1221775335858830398L, "满减满折"),

    @ApiModelProperty("秒杀活动")
    SECKILL_ACTIVITY(1221775335858830399L, "限时秒杀"),

    /**
     * 以下活动类型仅用于互斥判断
     */
    @ApiModelProperty("店铺券")
    SHOP_COUPON_ACTIVITY(1001775335858830001L, "店铺优惠券"),
    @ApiModelProperty("兑换券")
    EXCHANGE_COUPON_ACTIVITY(1001775335858830002L, "兑换券"),
    @ApiModelProperty("积分抵扣")
    POINT_DEDUCT_ACTIVITY(1001775335858830003L, "积分抵扣"),

    @ApiModelProperty("TOB满赠活动")
    FULL_PRESENT_TOB_ACTIVITY(5197154895685446737L, "满赠"),

    @ApiModelProperty("TOB满减活动")
    FULL_DECREASE_TOB_ACTIVITY(5197154895685446735L, "满减"),

    @ApiModelProperty("TOB满折活动")
    FULL_FOLD_TOB_ACTIVITY(5197154895685446734L, "满折"),

    @ApiModelProperty("TOB限时特价活动")
    TIME_DISCOUNT_TOB_ACTIVITY(5221775335858830397L,"限时特价活动"),

    @ApiModelProperty("TOB限时抢购活动")
    SECKILL_TOB_ACTIVITY(5221775335858830399L,"限时抢购活动"),

    @ApiModelProperty("TOB平台优惠券活动")
    COUPON_TOB_ACTIVITY(5221775335858830395L,"平台优惠券活动"),

    @ApiModelProperty("换购活动")
    EXCHANGE_ACTIVITY(1221775335858830402L, "换购"),

    @ApiModelProperty("优惠套装活动")
    COMBINATION_ACTIVITY(1221775335858830411L, "优惠套装活动"),
    ;

    long id;

    private String name;


    BizActivityType(long id, String name) {
        this.id = id;
        this.name = name;
    }

    public static BizActivityType getByType(Long id) {
        for (BizActivityType typeValue : values()) {
            if (Objects.equals(id, typeValue.getId())) {
                return typeValue;
            }
        }
        return null;
    }


    public long getId() {
        return id;
    }

    public String getName() {
        return name;
    }
}
