package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums;

/**
 * 促销方式：0不限，1促销价格，2折扣
 *
 * @author zhuiming
 * @date 2021/4/22
 */
public enum PromotionMethodEnum {

    /**
     * 促销价格
     */
    PROMOTION_PRICE(1, "促销价格"),
    /**
     * 折扣
     */
    DISCOUNT(2, "折扣"),

    ;

    private final Integer code;
    private final String name;

    PromotionMethodEnum(Integer code, String name) {
        this.code = code;
        this.name = name;
    }

    public Integer getCode() {
        return code;
    }

    public String getName() {
        return name;
    }


    public static PromotionMethodEnum fromCode(Integer status) {
        for (PromotionMethodEnum typeEnum : PromotionMethodEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static Integer toCode(Integer status) {
        PromotionMethodEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(Integer status) {
        PromotionMethodEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }
}
