/**
 * @(#)ActivityDimensionEnum.java 1.0 2020/5/13
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.enums;

/**
 * 活动商品选择范围类型
 */
public enum SelectTypeEnum {

    /**
     * 适用商品：0不限，1指定商品，2指定品类
     * Created by sumo on 2021/4/13 0013
     */
    ALL("0", "不限"),

    POINT_ITEM("1", "指定商品"),

    POINT_CAT("2", "指定品类"),
    ;


    private final String code;
    private final String name;

    SelectTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static SelectTypeEnum fromCode(String status) {
        for (SelectTypeEnum typeEnum : SelectTypeEnum.values()) {
            if (typeEnum.getCode().equals(status)) {
                return typeEnum;
            }
        }
        return null;
    }

    public static String toCode(String status) {
        SelectTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getCode();
    }

    public static String toName(String status) {
        SelectTypeEnum newEnum = fromCode(status);
        return newEnum == null ? null : newEnum.getName();
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }
}
