/**
 * @(#)ItemActivityTagRest.java 1.0 2020/5/20
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.fallback;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ItemActivityTagQueryReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service.query.IItemActivityTagQueryApi;
import com.github.pagehelper.PageInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 商品活动标签
 *
 * @author wu.sheng
 * @date 2020/5/20 18:16
 */
@Component
public class ItemActivityTagFallBack implements IItemActivityTagQueryApi {
   private static Logger logger = LoggerFactory.getLogger(ItemActivityTagFallBack.class);
    @Override
    public RestResponse<PageInfo<ItemActivityTagDto>> queryByPage(@SpringQueryMap ItemActivityTagQueryReqDto itemActivityTagQueryReqDto, Integer pageNum, Integer pageSize) {
        logger.info("IItemActivityTagQueryApi走熔断");
        PageInfo<ItemActivityTagDto> pageInfo=new PageInfo<>();
        return new RestResponse<>(pageInfo);
    }

    @Override
    public RestResponse<List<ItemActivityTagDto>> queryList(@SpringQueryMap ItemActivityTagQueryReqDto itemActivityTagQueryReqDto) {
        logger.info("IItemActivityTagQueryApi走熔断");
        List<ItemActivityTagDto> itemActivityTagDtos=new ArrayList<>();
        return new RestResponse<>(itemActivityTagDtos);
    }
}
