/*
 * *
 *  * @(#)IActionTemplateApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActionTemplateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:动作模版编辑API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IActionTemplateApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/action-template", url = "${yundt.cube.center.promotion.api:}")
public interface IActionTemplateApi {

    /**
     * 新增动作模版
     * @param dto 活动模版
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiOperation(value = "新增动作模版", notes = "新增动作模版")
    @ApiImplicitParams({@ApiImplicitParam(name = "coupon", value = "动作模板DTO", dataType = "ActionTemplateReqDto", paramType = "body", required = true)})
    RestResponse<Long> addActionTemplate(@Valid @RequestBody ActionTemplateReqDto dto);


    /**
     * 修改动作模版
     * @param dto 活动模版，除ID外其他被填充值即为修改项
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "修改动作模版", notes = "除ID外其他被填充值即为修改项")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "动作模板ID", dataType = "Long", paramType = "path", required = true),
            @ApiImplicitParam(name = "coupon", value = "动作模板DTO", dataType = "ActionTemplateReqDto", paramType = "body", required = true)
    })
    RestResponse<String> modifyActionTemplate(@Min(value = 1, message = "动作模板ID不能小于1") @PathVariable(name = "id") Long id, @Valid @RequestBody ActionTemplateReqDto dto);

    /**
     * 删除动作模版 -- 逻辑删除
     * @param atId 活动模版ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("/{atId}")
    @ResponseBody
    @ApiOperation(value = "删除动作模版", notes = "逻辑删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "atId", value = "动作模板ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteActionTemplate(@Min(value = 1, message = "动作模版ID不能小于1") @PathVariable(name = "atId") Long atId);
}
