/*
 * *
 *  * @(#)IActivityApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityAuditReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityCreateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * 活动服务接口
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IActivityApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/activity", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityApi {

    /**
     * 单个新增活动礼品
     *
     * @param activityCreateReqDto 规则
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coupon", value = "活动商品DTO", dataType = "ActivityCreateReqDto", paramType = "body", required = true),
    })
    RestResponse<Long> add(@RequestBody @Valid ActivityCreateReqDto activityCreateReqDto);

    /**
     * 编辑活动
     * @param id 活动ID
     * @param dto coupon
     * @return void
     */
    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "根据活动id编辑活动", notes = "编辑活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动id", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "ActivityCreateReqDto", value = "活动商品DTO", dataType = "ActivityCreateReqDto", paramType = "body", required = true)
    })
    RestResponse<String> modifyById(@Min(value = 1, message = "活动ID不能小于1") @PathVariable(name = "id") long id,
                                  @Valid @RequestBody ActivityCreateReqDto dto);

    /**
     * 删除活动，逻辑删除下挂所有信息（活动商品，活动用户，活动审批信息，优惠券，优惠券商品，优惠券用户，活动条件实例，活动动作实例）
     * 请谨慎操作
     * @param id 活动ID
     * @return
     */
    @DeleteMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "根据活动id删除活动", notes = "逻辑删除下挂所有信息（活动商品，活动用户，活动审批信息，优惠券，优惠券商品，优惠券用户，活动条件实例，活动动作实例）")
    RestResponse<String> deleteById(@Min(value = 1, message = "活动ID不能小于1") @PathVariable(name = "id") long id);

    /**
     * 审核活动
     *
     * @param id                  活动ID
     * @param activityAuditReqDto 审核操作内容
     * @return void
     */
    @PostMapping(value = "/{id}/activity-audit", produces = "application/json")
    @ApiOperation(value = "审核活动", notes = "审核活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动id", dataType = "Long", paramType = "query",required = true),
            @ApiImplicitParam(name = "ActivityAuditReqDto", value = "活动审批Dto", dataType = "ActivityAuditReqDto", paramType = "body", required = true)
    })
    RestResponse<String> auditById(@PathVariable("id") long id,
                                 @Valid @RequestBody ActivityAuditReqDto activityAuditReqDto);

    /**
     * 启用活动
     *
     * @return
     */
    @PutMapping(value = "/{id}/enable", produces = "application/json")
    @ApiOperation(value = "根据活动id启用活动", notes = "启用活动")
    RestResponse<String> enableById(@PathVariable("id") long id);

    /**
     * 暂停活动
     *
     * @return
     */
    @PutMapping(value = "/{id}/pause", produces = "application/json")
    @ApiOperation(value = "根据活动id暂停活动", notes = "暂停活动")
    RestResponse<String> pauseById(@PathVariable("id") long id);


    /**
     * 结束活动
     *
     * @return
     */
    @PutMapping(value = "/{id}/finish", produces = "application/json")
    @ApiOperation(value = "根据活动id结束活动", notes = "手动触发活动结束")
    RestResponse<String> finishById(@PathVariable("id") long id);

    /**
     * 结束活动
     *
     * @return
     */
    @PutMapping(value = "/{id}/finish/ready", produces = "application/json")
    @ApiOperation(value = "根据活动id结束活动状态为READY的活动", notes = "手动触发活动状态为READY的活动结束")
    RestResponse<String> finishActivityForReady(@PathVariable("id") long id);
}
