package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.DepositInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.request.PromotionPointInfoReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.DepositInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionGenInfoRespDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.promotion.dto.response.PromotionPointInfoRespDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * @author chen.fangliang
 * @date 2019/7/8 15:57
 */
@Api(tags = {"促销中心:活动定制API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-base-service-ISeckillActivityApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v2/activity/ext"
)
public interface IActivityExtApi {

    /**
     * 启用活动
     *
     * @param id 活动Id
     * @return 空
     */
    @PutMapping(value = {"/{id}/enable"})
    @ApiOperation(value = "根据活动id启用活动", notes = "根据活动id启用活动")
    RestResponse<Void> enableById(@PathVariable("id") Long id);

    /**
     * 批量启用活动
     *
     * @param ids 活动id集合
     * @return 操作结果
     */
    @PutMapping(value = {"/enable/batch"})
    @ApiOperation(value = "根据活动ids批量启用活动", notes = "根据活动ids批量启用活动")
    RestResponse<Void> enableBatch(@RequestBody List<Long> ids);

    /**
     * 禁用活动，会删除活动定时任务
     *
     * @param id 活动Id
     * @return 空
     */
    @PutMapping(value = {"/{id}/disable"})
    @ApiOperation(value = "根据活动id禁用活动", notes = "禁用活动,会删除活动定时任务")
    RestResponse<Void> disableById(@PathVariable("id") Long id);

    /**
     * 批量禁用活动
     *
     * @param ids 活动id集合
     */
    @PutMapping(value = {"/disable/batch"})
    @ApiOperation(value = "根据活动ids批量禁用活动", notes = "根据活动ids批量禁用活动")
    RestResponse<Void> disableBatch(@RequestBody List<Long> ids);

    /**
     * 根据id删除活动
     *
     * @param id 活动id
     */
    @DeleteMapping(value = {"/{id}/delete"})
    @ApiOperation(value = "根据活动id删除活动", notes = "根据活动id删除活动")
    RestResponse<Void> deleteById(@PathVariable("id") Long id);

    /**
     * 批量删除活动
     *
     * @param ids id集合
     */
    @DeleteMapping(value = {"/delete/batch"})
    @ApiOperation(value = "根据活动ids数组批量删除活动", notes = "根据活动ids数组批量删除活动")
    RestResponse<Void> deleteBatch(@RequestBody List<Long> ids);

    /**
     * 参与促销赠礼活动,当不存在可参与的活动时resultCode=11405
     *
     * @param dto 参数
     * @return 执行结果
     */
    @PostMapping("deposit")
    @ApiOperation(value = "根据储值参与促销赠礼活动", notes = "根据储值参与促销赠礼活动,充值金额是否达到促销活动的条件,赠送积分,商品等")
    RestResponse<DepositInfoRespDto> deposit(@RequestBody DepositInfoReqDto dto);

    /**
     * 参与普通促销活动,当不存在可参与的活动时resultCode=11405
     *
     * @param dto                参数
     * @param activityTemplateId 活动模版ID
     * @return 执行结果
     */
    @PostMapping("promotion/{activityTemplateId}")
    @ApiOperation(value = "根据促销活动模板id参与普通促销活动", notes = "根据促销活动模板id参与普通促销活动")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityTemplateId", value = "活动模板id", dataType = "Long", paramType = "path",required = true)

    })
    RestResponse<PromotionGenInfoRespDto> promotion(@RequestBody PromotionInfoReqDto dto,
                                                    @PathVariable("activityTemplateId") Long activityTemplateId);

    /**
     * 参与积分兑换促销活动,当不存在可参与的活动时resultCode=11405
     *
     * @param dto 参数
     * @return 执行结果
     */
    @PostMapping("promotion/points")
    @ApiOperation(value = "参与积分兑换促销活动", notes = "根据积分去兑换促销活动赠送的商品等")
    RestResponse<PromotionPointInfoRespDto> points(@RequestBody PromotionPointInfoReqDto dto);


}
