/*
 * *
 *  * @(#)IGiftApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import java.util.Collection;

/**
 * 活动商品操作API
 * 
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动商品操作API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IActivityItemApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/activity/item", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityItemApi {

	/**
     * 单个新增活动商品
     *
     * @param dto 活动商品dto
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiOperation(value = "单个新增活动商品", notes = "单个新增活动商品")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coupon", value = "活动商品DTO", dataType = "ActivityItemReqDto", paramType = "body", required = true)
    })
    RestResponse<Long> addActivityItem(@RequestBody @Valid ActivityItemReqDto dto);

    /**
     * 批量新增活动商品
     * 
     * @param dtos 活动商品dto
     * @return ids 顺序跟传入的集合一致
     */
    @PostMapping("batch")
    @ApiOperation(value = "批量新增活动商品", notes = "批量新增活动商品")
    RestResponse<Collection<Long>> addActivityItems(@RequestBody @Valid Collection<ActivityItemReqDto> dtos) ;

    /**
     * 修改活动商品
     *
     * @param id 活动商品ID
     * @param dto 活动礼品
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "修改活动商品", notes = "修改活动商品")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动商品ID", dataType = "Long", paramType = "path", required = true),
            @ApiImplicitParam(name = "coupon", value = "活动商品DTO", dataType = "ActivityItemReqDto", paramType = "body", required = true)
    })
    RestResponse<String> modifyActivityItem(@PathVariable(name = "id") Long id, @RequestBody @Valid ActivityItemReqDto dto);

    /**
     * 启用活动商品
     *
     * @param id 活动商品ID
     * @return
     */
    @PutMapping("/{id}/enabled")
    @ResponseBody
    @ApiOperation(value = "根据活动商品ID启用活动商品", notes = "启用活动商品(目前有逻辑问题 暂不使用)")
    @Deprecated
    RestResponse<String> enableById(@PathVariable(name = "id") Long id);
    
    /**
     * 禁用活动商品
     *
     * @param id 活动商品ID
     * @return
     */
    @PutMapping("/{id}/disabled")
    @ResponseBody
    @ApiOperation(value = "根据活动商品ID禁用活动商品", notes = "禁用活动商品(目前有逻辑问题 暂不使用)")
    @Deprecated
    RestResponse<String> disableById(@PathVariable(name = "id") Long id);
    
    /**
     * 删除活动商品
     *
     * @param id 活动商品ID
     * @return
     */
    @DeleteMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "根据活动商品ID删除活动商品", notes = "删除活动商品")
    RestResponse<String> deleteById(@PathVariable(name = "id") Long id);

    /**
     * 根据商品ID删除活动礼品 -- 逻辑删除
     *
     * @param  itemId ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("/item/{itemId}")
    @ResponseBody
    @ApiOperation(value = "通过商品ID删除活动商品", notes = "通过商品ID批量逻辑删除活动商品")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "itemId", value = "商品ID", dataType = "Long", paramType = "path", required = true)
    })
    @Deprecated
    RestResponse<String> deleteByItemId(@PathVariable(name = "itemId") Long itemId);

    /**
     * 根据活动ID删除活动礼品 -- 逻辑删除
     *
     * @param activityId ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("/activityId/{activityId}")
    @ResponseBody
    @ApiOperation(value = "通过活动id逻辑删除活动商品", notes = "通过活动id逻辑删除活动商品")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityId", value = "活动ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteByActId(@PathVariable(name = "activityId") Long activityId);

}
