/*
 * *
 *  * @(#)IActivityJoinLogExtService.java 2.0.0 8/17/19 11:58 AM
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Collection;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动定制API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-biz-marketing-api-activity-base-service-IActivityJoinLogExtApi", 
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        url = "${yundt.cube.center.promotion.api:}",
        path = "/v1/activity/log/ext"
)
public interface IActivityJoinLogExtApi {


    /**
     * 通过ID对参加记录进行失效处理
     *
     * @param ids 活动参与记录表ID
     * @return nothing 出现异常会直接抛错
     */
    @PutMapping("disable/ids")
    @ApiOperation(value = "过活动IDs对参加记录进行失效处理", notes = "过活动IDs对参加记录进行失效处理")
    RestResponse<String> disable(@RequestBody Collection<Long> ids);


    /**
     * 发送延迟mq消息，5s，用于积分兑换冲正
     *
     * @param payTradeCode 支付编号
     * @return void
     */
    @PutMapping("/sendDelayDisableMqMsg")
    @ApiOperation(value = "送延迟mq消息，5s，用于积分兑换冲正", notes = "送延迟mq消息，5s，用于积分兑换冲正")
    RestResponse<Void> sendDelayDisableMqMsg(@RequestParam("payTradeCode") String payTradeCode);

}
