/**
 * @(#)IActivityRelationApi.java 1.0 2021/3/15
 * <p>
 * Copyright (c) 2016, YUNXI. All rights reserved.
 * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRelationReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 活动关系服务
 *
 * @author wu.sheng
 * @date 2021/3/15 16:58
 */
@Api(tags = {"促销中心:活动关系服务"})
@FeignClient(contextId = "com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IActivityRelationApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v2/activity-relation",
        url = "${yundt.cube.center.promotion.api:}")
public interface IActivityRelationApi {

    @PostMapping("")
    @ApiOperation(value = "批量添加活动关系", notes = "批量添加活动关系")
    RestResponse<Void> add(@RequestBody List<ActivityRelationReqDto> relationReqDtos);


    @PostMapping("/{bizId}")
    @ApiOperation(value = "根据业务id添加活动关系(覆盖添加)", notes = "根据业务id添加活动关系(覆盖添加)")
    RestResponse<Void> add(@PathVariable("bizId") Long bizId,
                           @RequestBody List<ActivityRelationReqDto> relationReqDtos);
}
