package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityRuleItemReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;

/**
 * 服务接口
 *
 * @author yuangui
 * @since 2021-11-26
 */
@Api(tags = {"服务"})
@FeignClient(
        contextId = "com-dtyunxi-yundt-icom-bundle-base-center-promotion-api-IActivityRuleItemApi",
        name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}",
        path = "/v1/rule/item",
        url = "${yundt.cube.center.promotion.api:}"
)
public interface IActivityRuleItemApi {

    /**
     * 新增
     *
     * @param addReqDto 请求对象
     * @return 处理结果
     */
    @PostMapping("")
    @ApiOperation(value = "新增", notes = "新增")
    RestResponse<Long> addActivityRuleItem(@RequestBody ActivityRuleItemReqDto addReqDto);

    /**
     * 修改
     *
     * @param modifyReqDto 请求对象
     * @return 处理结果
     */
    @PutMapping("")
    @ApiOperation(value = "修改", notes = "修改")
    RestResponse<Void> modifyActivityRuleItem(@RequestBody ActivityRuleItemReqDto modifyReqDto);

    /**
     * 删除
     *
     * @param ids        删除数据ID
     * @param instanceId 实例ID
     * @return 处理结果
     */
    @DeleteMapping("/{ids}")
    @ApiOperation(value = "删除", notes = "删除")
    RestResponse<Void> removeActivityRuleItem(@PathVariable("ids") String ids,@RequestParam("instanceId") Long instanceId);
}
