/*
 * *
 *  * @(#)IActivityTemplateApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateCreateReqDto;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityTemplateUpdateReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * 活动服务接口
 *
 * @author 魄罗
 * @since 2.0.0
 */
@Api(tags = {"促销中心:活动模版服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IActivityTemplateApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/activity-template", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityTemplateApi {

    /**
     * 新增活动模版
     *
     * @param activityTemplateCreateReqDto 活动模版Dto
     * @return 主键ID
     */
    @PostMapping("")
    @ApiOperation(value = "新增活动模版", notes = "新增活动模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityTemplateCreateReqDto", value = "活动模板DTO", dataType = "ActivityTemplateCreateReqDto", paramType = "body", required = true)
    })
    RestResponse<Long> addActivityTemplate(@Valid @RequestBody ActivityTemplateCreateReqDto activityTemplateCreateReqDto);

    /**
     * 编辑活动模版
     *
     * @param id                           主键ID
     * @param activityTemplateUpdateReqDto 活动模版Dto
     * @return 操作结果
     */
    @PutMapping("/{id}")
    @ApiOperation(value = "根据活动模版ID更新活动模版", notes = "根据活动模版ID更新活动模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动模板ID", dataType = "Long", paramType = "path", required = true),
            @ApiImplicitParam(name = "coupon", value = "活动模板DTO", dataType = "ActivityTemplateUpdateReqDto", paramType = "body", required = true)
    })
    RestResponse<String> modifyActivityTemplate(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id,
                                              @RequestBody ActivityTemplateUpdateReqDto activityTemplateUpdateReqDto);


    /**
     * 删除活动模版
     *
     * @param id 主键ID
     * @return 操作结果
     */
    @DeleteMapping("/{id}")
    @ApiOperation(value = "根据活动模版ID删除活动模版", notes = "根据活动模版ID删除活动模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动模板ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteActivityTemplate(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 启用活动模版
     *
     * @param id 主键ID
     * @return 操作结果
     */
    @PutMapping("/enable/{id}")
    @ApiOperation(value = "根据活动模版ID启用活动模版", notes = "根据活动模版ID启用活动模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动模板ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> enableActivityTemplate(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

    /**
     * 禁用活动模版
     *
     * @param id 主键ID
     * @return 操作结果
     */
    @PutMapping("/disable/{id}")
    @ApiOperation(value = "根据活动模版ID禁用活动模版", notes = "根据活动模版ID禁用活动模版")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "活动模板ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> disableActivityTemplate(@NotNull(message = "ID不允许为空") @PathVariable("id") Long id);

}
