/*
 * *
 *  * @(#)IActivityUserMappingApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */
package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.ActivityUserMappingReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import javax.validation.Valid;
import javax.validation.constraints.NotNull;

/**
 * @author 双清
 */
@Api(tags = {"促销中心:活动参与人服务"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IActivityUserMappingApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/activity/user/mapping", url = "${yundt.cube.center.promotion.api:}")
public interface IActivityUserMappingApi {

    /**
     * 增加活动参与人群
     *
     * @param activityUserMappingReqDto 用户编号
     * @return 活动参与人群
     */
    @PostMapping("")
    @ApiOperation(value = "增加活动参与人群", notes = "增加活动参与人群")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityUserMappingReqDto", value = "活动参与人群DTO", dataType = "ActivityUserMappingReqDto", paramType = "body", required = true)
    })
    RestResponse<String> addActivityUserMapping(@Valid @RequestBody ActivityUserMappingReqDto activityUserMappingReqDto);

    /**
     * 根据活动实例编号删除活动参与人群
     *
     * @param activityInstanceId 活动实例编号
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("/{activityInstanceId}")
    @ApiOperation(value = "根据活动实例编号删除活动参与人群", notes = "根据活动实例编号删除活动参与人群")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "activityInstanceId", value = "活动实例编号", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteActivityUserMapping(@NotNull(message = "ID不允许为空") @PathVariable("activityInstanceId") Long activityInstanceId);
}