/*
 * *
 *  * @(#)ICheckPointApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.CheckPointReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:检查点服务接口API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-ICheckPointApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/check-point", url = "${yundt.cube.center.promotion.api:}")
public interface ICheckPointApi {

    /**
     * 新增检查点
     *
     * @param dto 检查点
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiOperation(value = "新增检查点", notes = "新增检查点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coupon", value = "检查点DTO", dataType = "CheckPointReqDto", paramType = "body", required = true)
    })
    RestResponse<Long> addCheckPoint(@Valid @RequestBody CheckPointReqDto dto);

    /**
     * 修改检查点
     *
     * @param dto 检查点，除ID外其他被填充值即为修改项
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{id}")
    @ResponseBody
    @ApiOperation(value = "修改检查点", notes = "除ID外其他被填充值即为修改项")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "检查点ID", dataType = "Long", paramType = "path", required = true),
            @ApiImplicitParam(name = "coupon", value = "检查点DTO", dataType = "CheckPointReqDto", paramType = "body", required = true)
    })
    RestResponse<String> modifyCheckPoint(@Min(value = 1, message = "检查点ID不能小于1") @PathVariable(name = "id") Long id,@Valid @RequestBody CheckPointReqDto dto);

    /**
     * 删除检查点 -- 逻辑删除
     *
     * @param cpId 检查点ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("{cpId}")
    @ResponseBody
    @ApiOperation(value = "删除检查点", notes = "逻辑删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "cpId", value = "检查点编号", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteCheckPoint(@Valid @Min(value = 1, message = "检查点ID不能小于1") @PathVariable(name = "cpId") Long cpId);


    /**
     * 启用检查点
     * @param cpId 检查点ID
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{cpId}/enable")
    @ResponseBody
    @ApiOperation(value = "启用检查点", notes = "启用检查点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "cpId", value = "检查点编号", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> enableCheckPoint(@Valid @Min(value = 1, message = "检查点ID不能小于1") @PathVariable(name = "cpId") Long cpId);

    /**
     * 禁用检查点
     * @param cpId 检查点ID
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{cpId}/disable")
    @ResponseBody
    @ApiOperation(value = "禁用检查点", notes = "禁用检查点")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "cpId", value = "检查点编号", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> disableCheckPoint(@Valid @Min(value = 1, message = "检查点ID不能小于1") @PathVariable(name = "cpId") Long cpId);


}
