/*
 * *
 *  * @(#)EngineApi.java 2.0.0 18-12-28 下午3:34
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.modle.EngineParams;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * 引擎入口
 *
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:引擎入口"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IEngineApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/engine", url = "${yundt.cube.center.promotion.api:}")
public interface IEngineApi {

    /**
     * 引擎启动入口，作用与活动事件的触发
     *
     * @param checkPoint 检查点
     * @param params     活动context
     * @return context
     */
    @PostMapping("/execute/{checkPoint}")
    @ResponseBody
    @ApiOperation(value = "引擎启动入口(同步)", notes = "作用与活动事件的触发")
    RestResponse<EngineParams> execute(@PathVariable("checkPoint") String checkPoint, @RequestBody EngineParams params);

    /**
     * 当你不关心执行结果，或者只是单纯触发一个检查点并不确定是否有活动时。可使用该接口
     * 该接口仅仅需要传入用户ID即可。未避免意外情况影响到你的业务流程，请手动catch异常并忽略即可。
     *
     * @param checkPoint 检查点
     * @param params     活动context
     * @return context
     */
    @PostMapping("/execute/async/{checkPoint}")
    @ResponseBody
    @ApiOperation(value = "引擎启动入口(异步)", notes = "作用与活动事件的触发")
    RestResponse<Void> asyncExecute(@PathVariable("checkPoint") String checkPoint, @RequestBody EngineParams params);
}
