package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.PolicyReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * 策略
 *
 * @author tuyun
 * @since 2.0.0
 */
@Api(tags = {"促销中心:策略配置信息API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IPolicyApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/policy", url = "${yundt.cube.center.promotion.api:}")
public interface IPolicyApi {

    /**
     * 新增策略信息
     *
     * @param dto 策略信息
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiOperation(value = "添加策略信息", notes = "添加策略信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "coupon", value = "策略信息DTO", dataType = "PolicyReqDto", paramType = "body", required = true)
    })
    RestResponse<Long> addPolicy(@RequestBody @Valid PolicyReqDto dto);

    /**
     * 修改策略信息
     *
     * @param pId 策略ID
     * @param dto 策略信息，除ID外其他被填充值即为修改项
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{pId}")
    @ResponseBody
    @ApiOperation(value = "修改策略信息", notes = "修改策略信息")
    RestResponse<String> modifyPolicy(@Min(value = 1, message = "策略信息ID不能小于1") @PathVariable(name = "pId") Long pId,
                                    @Valid @RequestBody PolicyReqDto dto);

    /**
     * 删除策略信息 -- 逻辑删除
     *
     * @param pId 策略信息ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("/{pId}")
    @ResponseBody
    @ApiOperation(value = "删除触发器", notes = "逻辑删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "pId", value = "策略信息编号", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deletePolicy(@Min(value = 1, message = "策略信息ID不能小于1") @PathVariable(name = "pId") Long pId);
}
