/*
 * *
 *  * @(#)IRuleApi.java 2.0.0 18-11-28 下午3:25
 *  * author: luo.lei
 *  * Copyright (c)  2018, YUNXI. All rights reserved.
 *  * YUNXI PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 */

package com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.service;

import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.icom.bundle.base.center.promotion.api.activity.base.dto.request.RuleReqDto;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.validation.Valid;
import javax.validation.constraints.Min;

/**
 * 规则编辑接口
 *
 * @author luo.lei
 * @since 2.0.0
 */
@Api(tags = {"促销中心:规则编辑API"})
@FeignClient(contextId="com-dtyunxi-yundt-cube-center-promotion-api-activity-base-service-IRuleApi", name = "${yundt.cube.center.promotion.api.name:yundt-cube-center-promotion}", path = "/v2/rule", url = "${yundt.cube.center.promotion.api:}")
public interface IRuleApi {

    /**
     * 新增规则
     *
     * @param dto 规则
     * @return id
     */
    @PostMapping("")
    @ResponseBody
    @ApiOperation(value = "新增规则", notes = "新增规则")
    RestResponse<Long> addRule(@Valid @RequestBody RuleReqDto dto);

    /**
     * 修改规则
     * @param ruleId 规则ID
     * @param dto 规则，除ID外其他被填充值即为修改项
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{ruleId}")
    @ResponseBody
    @ApiOperation(value = "修改规则", notes = "修改规则")
    RestResponse<String> modifyRule(@PathVariable("ruleId") long ruleId ,  @Valid @RequestBody RuleReqDto dto);

    /**
     * 删除规则 -- 逻辑删除
     *
     * @param ruleId ID
     * @return 无结果返回 不报错即为操作成功
     */
    @DeleteMapping("/{ruleId}")
    @ResponseBody
    @ApiOperation(value = "删除规则", notes = "逻辑删除")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ruleId", value = "规则编号ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> deleteRule(@Min(value = 1, message = "活动模版ID不能小于1") @PathVariable(name = "ruleId") Long ruleId);


    /**
     * 启用规则
     *
     * @param ruleId 规则ID
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{ruleId}/enable")
    @ResponseBody
    @ApiOperation(value = "启用规则", notes = "启用规则")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ruleId", value = "规则编号ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> enableRule(@Valid @Min(value = 1, message = "规则编号ID不能小于1") @PathVariable(name = "ruleId") Long ruleId);

    /**
     * 禁用规则L
     *
     * @param ruleId 规则ID
     * @return 无结果返回 不报错即为操作成功
     */
    @PutMapping("/{ruleId}/disable")
    @ResponseBody
    @ApiOperation(value = "禁用规则", notes = "禁用规则")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "ruleId", value = "规则编号ID", dataType = "Long", paramType = "path", required = true)
    })
    RestResponse<String> disableRule(@Valid @Min(value = 1, message = "检查点ID不能小于1") @PathVariable(name = "ruleId") Long ruleId);


}
